package com.devplatform.equipment.modules.eppatrolplan.dao;

import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.eppatrolplan.bean.EpPatrolPlan;
import com.devplatform.equipment.modules.eppatrolplan.model.EpPatrolPlanModel;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

/**
 * EpPatrolPlan Mapper 用于电子巡查计划表的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface EpPatrolPlanDao extends MyBaseMapper<EpPatrolPlan> {

  /**
   * 删除巡查计划
   * @param id
   * @param stationId
   * @param sysSign
   */
  void deleteByPlanId(@Param("id") String id, @Param("stationId") String stationId, @Param("sysSign") String sysSign);

  /**
   * 查询巡查计划数量
   * @param model
   * @return
   */
  Integer queryPageByCount(EpPatrolPlanModel model);

  /**
   * 查询巡查计划数据
   * @param model
   * @return
   */
  List<EpPatrolPlan> queryPageByList(EpPatrolPlanModel model);

  /**
   * 查询巡查计划数量
   * @param stationId
   * @param name
   * @return
   */
  Integer countByStationIdAndName(String stationId, String name);

  /**
   * 查询巡查计划数量
   * @param stationId
   * @param name
   * @param id
   * @return
   */
  Integer countByStationIdAndNameAndId(String stationId, String name, String id);

  /**
   * 查询巡查计划数量
   * @param lineId
   * @param stationId
   * @return
   */
  Integer countByLineId(String lineId, String stationId);
}
