package com.devplatform.equipment.modules.eppatrolplan.service;

import com.devplatform.common.service.MyBaseService;
import com.devplatform.equipment.modules.eppatrolplan.bean.EpPatrolPlan;
import com.devplatform.equipment.modules.eppatrolplan.model.EpPatrolPlanModel;
import java.util.List;
import java.util.Map;

/**
 * 电子巡查计划表的service接口 <br>
 * <b>功能：</b>EpPatrolPlanService<br>
 *
 * @author 代码生成器产生
 */
public interface EpPatrolPlanService extends MyBaseService<EpPatrolPlan> {
  /**
   * 级联添加
   *
   * @param bean
   * @param pointList
   */
  void saveCascade(EpPatrolPlan bean, List<Map<String, String>> pointList);

  /**
   * 级联更新
   *
   * @param bean
   * @param pointList
   */
  void updateCascade(EpPatrolPlan bean, List<Map<String, String>> pointList);

  /**
   * 级联删除
   * @param id
   * @param stationId
   * @param sysSign
   */
  void deleteById(String id, String stationId,String sysSign);

  /**
   * 分页查询
   * @param model
   * @return
   */
  List<EpPatrolPlan> queryPageByList(EpPatrolPlanModel model);

  /**
   * 查询数量
   * @param stationId
   * @param name
   * @return
   */
  Integer countByStationIdAndName(String stationId, String name);

  /**
   * 查询数量
   * @param stationId
   * @param name
   * @param id
   * @return
   */
  Integer countByStationIdAndNameAndId(String stationId, String name, String id);

  /**
   * 根据巡查线路Id统计被加入的电子巡查计划条数
   * @param id
   * @param stationId
   * @return
   */
  Integer countByLineId(String id, String stationId);
}
