package com.devplatform.equipment.modules.eppatrolplan.service.impl;

import com.devplatform.common.service.impl.MyBaseServiceImpl;
import com.devplatform.equipment.modules.eppatrolplan.bean.EpPatrolPlan;
import com.devplatform.equipment.modules.eppatrolplan.dao.EpPatrolPlanDao;
import com.devplatform.equipment.modules.eppatrolplan.model.EpPatrolPlanModel;
import com.devplatform.equipment.modules.eppatrolplan.service.EpPatrolPlanService;
import com.devplatform.equipment.modules.eppatrolplanpoint.bean.EpPatrolPlanPoint;
import com.devplatform.equipment.modules.eppatrolplanpoint.service.EpPatrolPlanPointService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 电子巡查计划表的service接口实现类 <br>
 * <b>功能：</b>EpPatrolPlanServiceImpl<br>
 *
 * @author 代码生成器产生
 */
@Service("epPatrolPlanService")
public class EpPatrolPlanServiceImpl extends MyBaseServiceImpl<EpPatrolPlanDao, EpPatrolPlan>
    implements EpPatrolPlanService {

  @Autowired private EpPatrolPlanPointService epPatrolPlanPointService;

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void saveCascade(EpPatrolPlan bean, List<Map<String, String>> pointList) {
    save(bean);
    // 保存巡查计划巡查点
    ArrayList<EpPatrolPlanPoint> list = new ArrayList<>();
    for (int i = 0; i < pointList.size(); i++) {
      EpPatrolPlanPoint epPatrolPlanPoint = new EpPatrolPlanPoint();
      epPatrolPlanPoint.setPlanId(bean.getId());
      epPatrolPlanPoint.setPointId(pointList.get(i).get("pointId"));
      epPatrolPlanPoint.setPointName(pointList.get(i).get("pointName"));
      epPatrolPlanPoint.setArrivalTime(pointList.get(i).get("arrivalTime"));
      epPatrolPlanPoint.setCreateUserId(bean.getCreateUserId());
      epPatrolPlanPoint.setCreateTime(bean.getCreateTime());
      epPatrolPlanPoint.setSysSign(bean.getSysSign());
      epPatrolPlanPoint.setStationId(bean.getStationId());
      list.add(epPatrolPlanPoint);
    }
    epPatrolPlanPointService.saveBatch(list);
  }

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void updateCascade(EpPatrolPlan bean, List<Map<String, String>> pointList) {
    updateById(bean);

    // 删除巡查计划所有巡查点
    epPatrolPlanPointService.deleteByPlanId(bean.getId(), bean.getStationId(),bean.getSysSign());
    // 保存巡查计划巡查点
    if (pointList.isEmpty()) {
      return;
    }
    ArrayList<EpPatrolPlanPoint> list = new ArrayList<>();
    for (int i = 0; i < pointList.size(); i++) {
      EpPatrolPlanPoint epPatrolPlanPoint = new EpPatrolPlanPoint();
      epPatrolPlanPoint.setPlanId(bean.getId());
      epPatrolPlanPoint.setPointId(pointList.get(i).get("pointId"));
      epPatrolPlanPoint.setPointName(pointList.get(i).get("pointName"));
      epPatrolPlanPoint.setArrivalTime(pointList.get(i).get("arrivalTime"));
      epPatrolPlanPoint.setCreateUserId(bean.getCreateUserId());
      epPatrolPlanPoint.setCreateTime(bean.getCreateTime());
      epPatrolPlanPoint.setSysSign(bean.getSysSign());
      epPatrolPlanPoint.setStationId(bean.getStationId());
      list.add(epPatrolPlanPoint);
    }
    epPatrolPlanPointService.saveBatch(list);
  }

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void deleteById(String id, String stationId,String sysSign) {
    // 根据主键逻辑删除
    baseMapper.deleteByPlanId(id, stationId,sysSign);
    epPatrolPlanPointService.deleteByPlanId(id, stationId,sysSign);
  }

  @Override
  public List<EpPatrolPlan> queryPageByList(EpPatrolPlanModel model) {
    Integer rowCount = baseMapper.queryPageByCount(model);
    model.getPager().setRowCount(rowCount);
    return baseMapper.queryPageByList(model);
  }

  @Override
  public Integer countByStationIdAndName(String stationId, String name) {
    return baseMapper.countByStationIdAndName(stationId, name);
  }

  @Override
  public Integer countByStationIdAndNameAndId(String stationId, String name, String id) {
    return baseMapper.countByStationIdAndNameAndId(stationId, name, id);
  }

  @Override
  public Integer countByLineId(String id, String stationId) {
    return baseMapper.countByLineId(id, stationId);
  }
}
