package com.devplatform.equipment.modules.eppatrolplanpoint.dao;

import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.eppatrolplanpoint.bean.EpPatrolPlanPoint;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

/**
 * EpPatrolPlanPoint Mapper 用于电子巡查计划巡查点表的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface EpPatrolPlanPointDao extends MyBaseMapper<EpPatrolPlanPoint> {

  /**
   * 根据巡查计划id删除巡查点
   * @param planId
   * @param stationId
   * @param sysSign
   */
  void deleteByPlanId(@Param("planId") String planId, @Param("stationId") String stationId, @Param("sysSign") String sysSign);

  /**
   * 查询计划的巡查点
   * @param planId
   * @param stationId
   * @return
   */
  List<EpPatrolPlanPoint> getByPlanId(String planId, String stationId);
}
