package com.devplatform.equipment.modules.eppatrolpoint.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.devplatform.common.base.validator.ValidatorUtils;
import com.devplatform.common.util.R;
import com.devplatform.common.util.StringUtil;
import com.devplatform.equipment.common.annotation.SysLogMethod;
import com.devplatform.equipment.common.utils.AbstractController;
import com.devplatform.equipment.modules.eppatrollinepoint.service.EpPatrolLinePointService;
import com.devplatform.equipment.modules.eppatrolpoint.bean.EpPatrolPoint;
import com.devplatform.equipment.modules.eppatrolpoint.model.EpPatrolPointModel;
import com.devplatform.equipment.modules.eppatrolpoint.service.EpPatrolPointService;
import com.devplatform.equipment.modules.eppointenshrine.bean.EpPointEnshrine;
import com.devplatform.equipment.modules.eppointenshrine.service.EpPointEnshrineService;
import com.devplatform.equipment.modules.listationmap.bean.LiStationMap;
import com.devplatform.equipment.modules.listationmap.model.LiStationMapModel;
import com.devplatform.equipment.modules.listationmap.service.LiStationMapService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Administrator
 */
@Api(tags = {"电子巡查点管理接口"})
@RestController
@RequestMapping("/epPatrolPoint")
public class EpPatrolPointController extends AbstractController {

  @Autowired private LiStationMapService liStationMapService;

  @Autowired private EpPatrolPointService epPatrolPointService;

  @Autowired private EpPatrolLinePointService epPatrolLinePointService;

  @Autowired private EpPointEnshrineService epPointEnshrineService;

  /**
   * 列表页面列表数据获取
   *
   * @param model 承接对象 stationId 站点id name 巡查点名称(模糊查询)
   * @return
   */
  @ApiOperation(value = "根据条件获取电子巡查点管理分页数据列表", notes = "根据条件获取电子巡查点管理分页数据列表")
  @ApiImplicitParam(
      name = "model",
      value = "承接对象",
      required = true,
      dataType = "EpPatrolPointModel")
  @PostMapping("/list")
  public R list(@RequestBody EpPatrolPointModel model) {
    List<Map<String, Object>> nodes = new ArrayList<>();

    LiStationMapModel liStationMapModel = new LiStationMapModel();
    liStationMapModel.setStationId(model.getStationId());
    // 查询当前站点相应所有层级
    List<LiStationMap> list = liStationMapService.getTreeList(liStationMapModel);
    if (list != null && list.size() > 0) {
      for (int i = 0; i < list.size(); i++) {
        Map<String, Object> map = JSONObject.parseObject(JSONObject.toJSONString(list.get(i)), Map.class);
	// 站层等级
        map.put("level", 4);
	// 站层id
        model.setLayerId(list.get(i).getId());
        model.setName(model.getName());

        // 查询当前站层下，所有符合条件的巡查点
        List<EpPatrolPoint> epPatrolPointList = epPatrolPointService.getTreeListByModel(model);
        if (epPatrolPointList != null && epPatrolPointList.size() > 0) {
          List<Map<String, Object>> childrenDic = new ArrayList<>();
          for (int j = 0; j < epPatrolPointList.size(); j++) {
            Map<String, Object> mapChildren =
                JSONObject.parseObject(
                    JSONObject.toJSONString(epPatrolPointList.get(j)), Map.class);
            ;
	// 等级
            mapChildren.put("level", 6);
            mapChildren.put("filePath", list.get(i).getFilePath());
            mapChildren.put("readPath", list.get(i).getReadPath());
            childrenDic.add(mapChildren);
          }
	// 把当前站层下所有的资源点，绑定到站层上
          map.put("children", childrenDic);
        }
	// 把当前站层所有数据，让如树中
        nodes.add(map);
      }
    }
    return R.ok().put("nodes", nodes);
  }

  /**
   * 添加 layerId 站层id stationId 站点id name 巡查点名称 coordinateX 巡查点x坐标 coordinateY 巡查点y坐标
   *
   * @param bean 电子巡查点管理对象
   * @return
   */
  @SysLogMethod(operation = "新增", blockName = "电子巡更", detail = "新增电子巡查点数据")
  @ApiOperation(value = "新增电子巡查点管理数据", notes = "新增电子巡查点管理数据")
  @PostMapping("/save")
  public R save(@RequestBody @ApiParam(value = "电子巡查点管理实体对象", required = true) EpPatrolPoint bean) {
    ValidatorUtils.validateEntity(bean);
    bean.setCreateUserId(getUserId());
    bean.setCreateTime(new Date());
    bean.setSysSign(getUser().getSysSystem().getCode());
    epPatrolPointService.save(bean);
    return R.ok().put("bean", bean);
  }

  @SysLogMethod(operation = "修改", blockName = "电子巡更", detail = "修改电子巡查点数据")
  @ApiOperation(value = "修改电子巡查点管理数据", notes = "修改电子巡查点管理数据")
  @PostMapping("/update")
  public R update(
      @RequestBody @ApiParam(value = "电子巡查点管理实体对象", required = true) EpPatrolPoint bean) {
    ValidatorUtils.validateEntity(bean);
    bean.setUpdateUserId(getUserId());
    bean.setUpdateTime(new Date());
    bean.setSysSign(getUser().getSysSystem().getCode());
    epPatrolPointService.update(bean, new QueryWrapper<EpPatrolPoint>().eq("id", bean.getId()));
    return R.ok().put("bean", bean);
  }

  /**
   * 修改
   *
   * @param beanList 电子巡查点管理对象 stationId 站点id layerId 站层id id 巡查点id name 巡查点名称 coordinateX 巡查点x坐标
   *     coordinateY 巡查点y坐标
   * @return
   */
  @SysLogMethod(operation = "修改", blockName = "电子巡更", detail = "修改多个电子巡查点")
  @ApiOperation(value = "修改多个电子巡查点", notes = "修改多个电子巡查点")
  @PostMapping("/updateList")
  public R updateList(
      @RequestBody @ApiParam(value = "电子巡查点管理实体对象集合", required = true)
          List<EpPatrolPoint> beanList) {
    ArrayList<EpPatrolPoint> updateList = new ArrayList<>();
    ArrayList<EpPatrolPoint> insertList = new ArrayList<>();
    String userId = getUserId();
    Date date = new Date();
    String code = getUser().getSysSystem().getCode();
    for (EpPatrolPoint epPatrolPoint : beanList) {
      if ("save".equals(epPatrolPoint.getAddOrUpdate())) {
        // 新增
        if (0 == epPatrolPoint.getDeleted()) {
          epPatrolPoint.setId(null);
          epPatrolPoint.setCreateUserId(userId);
          epPatrolPoint.setCreateTime(date);
          epPatrolPoint.setSysSign(code);
          insertList.add(epPatrolPoint);
        }
      } else {
        // 修改
        if (epPatrolLinePointService.countByPatrolId(
                epPatrolPoint.getId(), epPatrolPoint.getStationId())
            > 0) {
          // 判断此巡查点有没有被加入巡查路线，有则不能修改 ，不加入修改集合 ,跳过
          continue;
        }
        epPatrolPoint.setUpdateUserId(userId);
        epPatrolPoint.setUpdateTime(date);
        epPatrolPoint.setSysSign(code);
        updateList.add(epPatrolPoint);
      }
    }
    if (insertList.size() > 0) {
      epPatrolPointService.saveBatch(insertList);
    }
    if (updateList.size() > 0) {
      epPatrolPointService.updateBatchById(updateList);
    }
    return R.ok("新增成功或未被使用的巡查点修改成功");
  }

  /**
   * 根据ID获取电子巡查点管理对象 删除的时候制定了巡查线路的巡查点不能删除
   *
   * @param epPatrolPoint 电子巡查点管理对象
   * @return
   */
  @SysLogMethod(operation = "删除", blockName = "电子巡更", detail = "删除电子巡查点数据")
  @ApiOperation(value = "根据ID删除电子巡查点管理数据", notes = "根据ID删除电子巡查点管理数据")
  @PostMapping("/delete")
  public R delete(@RequestBody EpPatrolPoint epPatrolPoint) {
    if (StringUtil.checkNotNull(epPatrolPoint.getId())) {
      // 判断此巡查点有没有被加入巡查路线，有则不删除 ，且给提示信息 此巡查点已有巡查路线，不能删除
      if (epPatrolLinePointService.countByPatrolId(
              epPatrolPoint.getId(), epPatrolPoint.getStationId())
          <= 0) {
        epPatrolPointService.deleteById(epPatrolPoint.getId(), epPatrolPoint.getStationId());
        EpPointEnshrine epPointEnshrine = new EpPointEnshrine();
        epPointEnshrine.setDeleted(1);
        epPointEnshrine.setSysSign(getUser().getSysSystem().getCode());
        // 删除收藏夹数据
        epPointEnshrineService.update(
            epPointEnshrine,
            new LambdaQueryWrapper<EpPointEnshrine>()
                .eq(EpPointEnshrine::getPointId, epPatrolPoint.getId())
                .eq(EpPointEnshrine::getDeleted, 0)
                .eq(
                    StringUtil.checkNotNull(epPatrolPoint.getStationId()),
                    EpPointEnshrine::getStationId,
                    epPatrolPoint.getStationId()));
      } else {
        return R.error("此巡查点已被加入巡查路线，不能删除");
      }
    }
    return R.ok();
  }

  /**
   * 查看详情 根据ID获取巡查点对象
   *
   * @param id 对象主键
   * @return
   */
  @SysLogMethod(operation = "查看", blockName = "电子巡更", detail = "查看巡查点详情")
  @GetMapping("/viewInfo")
  public R viewInfo(String id, String stationId) {
    EpPatrolPoint bean =
        epPatrolPointService.getOne(
            new LambdaQueryWrapper<EpPatrolPoint>()
                .eq(EpPatrolPoint::getId, id)
                .eq(EpPatrolPoint::getStationId, stationId));
    return R.ok().put("bean", bean);
  }
}
