package com.devplatform.equipment.modules.eppatrolpoint.dao;

import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.eppatrolpoint.bean.EpPatrolPoint;
import com.devplatform.equipment.modules.eppatrolpoint.model.EpPatrolPointModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

/**
 * EpPatrolPoint Mapper 用于电子巡查点管理的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface EpPatrolPointDao extends MyBaseMapper<EpPatrolPoint> {

  /**
   * 删除巡查点
   * @param id
   * @param stationId
   */
  void deleteByPointId(String id, String stationId);

  /**
   * 查询巡查点
   * @param model
   * @return
   */
  List<EpPatrolPoint> getTreeListByModel(EpPatrolPointModel model);

  /**
   * 根据ids查询巡查点
   * @param list
   * @param stationId
   * @return
   */
  List<EpPatrolPoint> getByIds(ArrayList<String> list, String stationId);
}
