package com.devplatform.equipment.modules.eppatrolpoint.service;

import com.devplatform.common.service.MyBaseService;
import com.devplatform.equipment.modules.eppatrolpoint.bean.EpPatrolPoint;
import com.devplatform.equipment.modules.eppatrolpoint.model.EpPatrolPointModel;
import java.util.ArrayList;
import java.util.List;

/**
 * 电子巡查点管理的service接口 <br>
 * <b>功能：</b>EpPatrolPointService<br>
 *
 * @author 代码生成器产生
 */
public interface EpPatrolPointService extends MyBaseService<EpPatrolPoint> {
  /**
   * 根据主键逻辑删除
   * @param id
   * @param stationId
   */
  void deleteById(String id, String stationId);

  /**
   * 查询巡查点
   * @param model
   * @return
   */
  List<EpPatrolPoint> getTreeListByModel(EpPatrolPointModel model);

  /**
   * 根据id集合获取巡查点集合
   * @param ids
   * @param stationId
   * @return
   */
  List<EpPatrolPoint> getByIds(ArrayList<String> ids, String stationId);

  /**
   * 修改和新增资源点
   *
   * @param updateList 修改集合
   * @param insertList 新增集合
   *
   */
  void updateList(List<EpPatrolPoint> updateList, List<EpPatrolPoint> insertList);
}
