package com.devplatform.equipment.modules.eppatrolpoint.service.impl;

import com.devplatform.common.service.impl.MyBaseServiceImpl;
import com.devplatform.equipment.modules.eppatrolpoint.bean.EpPatrolPoint;
import com.devplatform.equipment.modules.eppatrolpoint.dao.EpPatrolPointDao;
import com.devplatform.equipment.modules.eppatrolpoint.model.EpPatrolPointModel;
import com.devplatform.equipment.modules.eppatrolpoint.service.EpPatrolPointService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 电子巡查点管理的service接口实现类 <br>
 * <b>功能：</b>EpPatrolPointServiceImpl<br>
 *
 * @author 代码生成器产生
 */
@Service("epPatrolPointService")
public class EpPatrolPointServiceImpl extends MyBaseServiceImpl<EpPatrolPointDao, EpPatrolPoint>
    implements EpPatrolPointService {

  @Override
  public void deleteById(String id, String stationId) {
    baseMapper.deleteByPointId(id, stationId);
  }

  @Override
  public List<EpPatrolPoint> getTreeListByModel(EpPatrolPointModel model) {
    return baseMapper.getTreeListByModel(model);
  }

  @Override
  public List<EpPatrolPoint> getByIds(ArrayList<String> ids, String stationId) {
    return baseMapper.getByIds(ids, stationId);
  }

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void updateList(List<EpPatrolPoint> updateList, List<EpPatrolPoint> insertList) {

    if (insertList.size() > 0) {
      saveBatch(insertList);
    }
    if (updateList.size() > 0) {
      updateBatchById(updateList);
    }
  }
}
