package com.devplatform.equipment.modules.eppatrolpointresult.controller;

import com.devplatform.common.base.annotation.SysLog;
import com.devplatform.common.util.PageUtils;
import com.devplatform.common.util.R;
import com.devplatform.equipment.common.annotation.SysLogMethod;
import com.devplatform.equipment.common.utils.AbstractController;
import com.devplatform.equipment.modules.eppatrolpointresult.bean.EpPatrolPointResult;
import com.devplatform.equipment.modules.eppatrolpointresult.service.EpPatrolPointResultService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Administrator
 */
@Api(tags = {"电子巡查巡查点结果表接口"})
@RestController
@RequestMapping("/epPatrolPointResult")
public class EpPatrolPointResultController extends AbstractController {

  @Autowired private EpPatrolPointResultService epPatrolPointResultService;

  /**
   * 列表页面列表数据获取
   *
   * @param model 承接对象
   * @return
   */
  @ApiOperation(value = "根据条件获取电子巡查巡查点结果表分页数据列表", notes = "根据条件获取电子巡查巡查点结果表分页数据列表")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, Object>")
  @PostMapping("/list")
  public R list(@RequestParam Map<String, Object> params) {
    PageUtils page = epPatrolPointResultService.queryPage(params, null);
    return R.ok().put("page", page);
  }

  /**
   * 根据ID获取电子巡查巡查点结果表对象
   *
   * @param id 对象主键
   * @return
   */
  @ApiOperation(value = "根据ID获取电子巡查巡查点结果表对象", notes = "根据ID获取电子巡查巡查点结果表对象")
  @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
  @GetMapping("/getId/{id}")
  public R getId(@PathVariable String id) {
    EpPatrolPointResult bean = epPatrolPointResultService.getById(id);
    return R.ok().put("bean", bean);
  }

  /**
   * 根据ID获取电子巡查巡查点结果表对象
   *
   * @param id[] 电子巡查巡查点结果表对象主键数组
   * @return
   */
  @SysLog("删除电子巡查巡查点结果表")
  @SysLogMethod(operation = "删除", blockName = "电子巡查巡查点结果表", detail = "删除电子巡查巡查点结果表数据")
  @ApiOperation(value = "根据ID批量删除电子巡查巡查点结果表数据", notes = "根据ID批量删除电子巡查巡查点结果表数据")
  @ApiImplicitParam(name = "ids", value = "主键数组", required = true, dataType = "String")
  @PostMapping("/delete")
  public R delete(@RequestBody String[] ids) {
    epPatrolPointResultService.removeByIds(Arrays.asList(ids));
    return R.ok();
  }
}
