package com.devplatform.equipment.modules.eppatrolresult.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.devplatform.common.util.R;
import com.devplatform.common.util.StringUtil;
import com.devplatform.equipment.common.annotation.SysLogMethod;
import com.devplatform.equipment.common.utils.AbstractController;
import com.devplatform.equipment.modules.eppatrolpointresult.bean.EpPatrolPointResult;
import com.devplatform.equipment.modules.eppatrolpointresult.service.EpPatrolPointResultService;
import com.devplatform.equipment.modules.eppatrolresult.bean.EpPatrolResult;
import com.devplatform.equipment.modules.eppatrolresult.model.EpPatrolResultModel;
import com.devplatform.equipment.modules.eppatrolresult.service.EpPatrolResultService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Administrator
 */
@Api(tags = {"电子巡查结果表接口"})
@RestController
@RequestMapping("/epPatrolResult")
public class EpPatrolResultController extends AbstractController {

  @Autowired private EpPatrolResultService epPatrolResultService;

  @Autowired private EpPatrolPointResultService epPatrolPointResultService;

  /**
   * 列表页面列表数据获取
   *
   * @param model 承接对象 stationId 站点id keywords 可能是计划名称 线路名称 巡查员姓名 page 页码 rows 行数
   * @return
   */
  @ApiOperation(value = "根据条件获取电子巡查结果表分页数据列表", notes = "根据条件获取电子巡查结果表分页数据列表")
  @ApiImplicitParam(name = "model", value = "参数", required = true, dataType = "EpPatrolResultModel")
  @PostMapping("/list")
  public R list(@RequestBody EpPatrolResultModel model) {
    if (StringUtil.isEmpty(model.getSort())) {
      model.setSort("create_time");
      model.setOrder("DESC");
    }
    if (StringUtil.checkNotNull(model.getKeywords())) {
      model.setKeywords(model.getKeywords());
    }
    List<EpPatrolResult> list = epPatrolResultService.queryPageByList(model);
    return R.ok().put("page", getMyPage(list, model));
  }

  /**
   * 根据ID获取电子巡查结果表详情对象
   *
   * @param id 对象主键
   * @return
   */
  @SysLogMethod(operation = "查看", blockName = "电子巡更", detail = "查看巡查结果详情")
  @ApiOperation(value = "根据ID获取电子巡查结果表详情对象", notes = "根据ID获取电子巡查结果表详情对象")
  @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
  @GetMapping("/getId")
  public R getId(String id, String stationId) {
    EpPatrolResult epPatrolResult = epPatrolResultService.getOne(new LambdaQueryWrapper<EpPatrolResult>().eq(EpPatrolResult::getId, id)
                .eq(StringUtil.checkNotNull(stationId), EpPatrolResult::getStationId, stationId));
	// 获取当前结果下所有巡查点结果
    List<EpPatrolPointResult> list = epPatrolPointResultService.getByResultId(id, stationId);
    Map map = new LinkedHashMap<String, Object>();
	// 计划名称
    map.put("planName", epPatrolResult.getPlanName());
	// 线路名称
    map.put("lineName", epPatrolResult.getLineName());
	// 状态
    map.put("status", epPatrolResult.getStatus());
	// 开始时间
    map.put("startTime", epPatrolResult.getStartTime());
	// 结束时间
    map.put("endTime", epPatrolResult.getEndTime());
	// 巡查员姓名
    map.put("patrollerName", epPatrolResult.getPatrollerName());
	// 计划次数
    map.put("planTimes", epPatrolResult.getPlanTimes());
	// 到达次数
    map.put("arriveTimes", epPatrolResult.getArriveTimes());
	// 漏检次数
    map.put("missedTimes", epPatrolResult.getMissedTimes());
	// 漏检率
    map.put("missedRate", epPatrolResult.getMissedRate() + "%");
    ArrayList<Map<String, Object>> pointList = new ArrayList<>();
    for (EpPatrolPointResult epPatrolPointResult : list) {
      Map<String, Object> lmap = new LinkedHashMap<>();
	// 巡查点id
      lmap.put("pointId", epPatrolPointResult.getPointId());
	// 巡查点名字
      lmap.put("pointName", epPatrolPointResult.getPointName());
	// 巡查时间
      lmap.put("patrolTime", epPatrolPointResult.getPatrolTime());
	// 状态
      lmap.put("patrolStatus", epPatrolPointResult.getPatrolStatus());
      pointList.add(lmap);
    }
    map.put("pointList", pointList);
    return R.ok().put("bean", map);
  }
}
