package com.devplatform.equipment.modules.eppatrolresult.dao;

import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.eppatrolresult.bean.EpPatrolResult;
import com.devplatform.equipment.modules.eppatrolresult.model.EpPatrolResultModel;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

/**
 * EpPatrolResult Mapper 用于电子巡查结果表的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface EpPatrolResultDao extends MyBaseMapper<EpPatrolResult> {

  /**
   * 查询巡查结果数量
   * @param model
   * @return
   */
  Integer queryPageByCount(EpPatrolResultModel model);

  /**
   * 查询巡查结果数据
   * @param model
   * @return
   */
  List<EpPatrolResult> queryPageByList(EpPatrolResultModel model);

  /**
   * 根据计划id查询巡查结果数量
   * @param id
   * @param stationId
   * @return
   */
  Integer countByPlanId(String id, String stationId);
}
