package com.devplatform.equipment.modules.eppointenshrine.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.devplatform.common.base.annotation.SysLog;
import com.devplatform.common.base.validator.ValidatorUtils;
import com.devplatform.common.util.R;
import com.devplatform.common.util.StringUtil;
import com.devplatform.equipment.common.annotation.SysLogMethod;
import com.devplatform.equipment.common.utils.AbstractController;
import com.devplatform.equipment.common.utils.Constants;
import com.devplatform.equipment.modules.eppatrolpoint.bean.EpPatrolPoint;
import com.devplatform.equipment.modules.eppatrolpoint.service.EpPatrolPointService;
import com.devplatform.equipment.modules.eppointenshrine.bean.EpPointEnshrine;
import com.devplatform.equipment.modules.eppointenshrine.service.EpPointEnshrineService;
import com.devplatform.equipment.modules.listationmap.bean.LiStationMap;
import com.devplatform.equipment.modules.listationmap.model.LiStationMapModel;
import com.devplatform.equipment.modules.listationmap.service.LiStationMapService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Administrator
 */
@Api(tags = {"巡查点收藏夹接口"})
@RestController
@RequestMapping("/epPointEnshrine")
public class EpPointEnshrineController extends AbstractController {

  @Autowired private EpPointEnshrineService epPointEnshrineService;

  @Autowired private EpPatrolPointService epPatrolPointService;

  @Autowired private LiStationMapService liStationMapService;

  /**
   * 列表页面列表数据获取 stationId 站点id name 巡查点名字
   *
   * @param params 承接对象
   * @return
   */
  @ApiOperation(value = "根据站点id和巡查点名字获取巡查点收藏夹列表", notes = "根据站点id和巡查点名字获取巡查点收藏夹列表")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, String>")
  @PostMapping("/getEnshrinePointTreeList")
  public R getEnshrinePointTreeList(@RequestBody Map<String, String> params) {
    // 查出当前用户收藏的所有巡查点
    String stationId = params.get("stationId");
    List<EpPointEnshrine> epPointEnshrineList =
        epPointEnshrineService.getByCreateUserId(getUserId(), stationId);
    if (epPointEnshrineList == null || epPointEnshrineList.size() <= 0) {
      // 没有收藏，返回null
      return R.ok().put("nodes", null);
    }
    ArrayList<String> ids = new ArrayList<>();
    // 将收藏巡查点的id加入集合
    epPointEnshrineList.forEach(
        (epPointEnshrine -> {
          ids.add(epPointEnshrine.getPointId());
        }));
    // 查出收藏的所有巡查点
    List<EpPatrolPoint> epPatrolPointList = epPatrolPointService.getByIds(ids, stationId);
    // 如果传入巡查点名字，就根据传入的巡查点名过滤不符合的
    if (StringUtil.checkNotNull(params.get(Constants.NAME_WORD))) {

      epPatrolPointList =
          epPatrolPointList.stream()
              .filter(
                  (epPatrolPoint) -> {
                    return epPatrolPoint.getName().contains(params.get("name"));
                  })
              .collect(Collectors.toList());
    }

    List<Map<String, Object>> nodes = new ArrayList<>();
    // 查询当前站点相应所有层级
    LiStationMapModel model = new LiStationMapModel();
    model.setStationId(stationId);
    List<LiStationMap> list = liStationMapService.getTreeList(model);
    if (list != null && list.size() > 0) {
      for (int i = 0; i < list.size(); i++) {
        Map<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("id", list.get(i).getId());
	// 站层名称
        map.put("name", list.get(i).getName());
	// 站层等级
        map.put("level", 4);
        map.put("stationId", list.get(i).getStationId());
        map.put("filePath", list.get(i).getFilePath());
        map.put("readPath", list.get(i).getReadPath());

        List<Map<String, Object>> childrenDic = new ArrayList<>();
        if (epPatrolPointList != null && epPatrolPointList.size() > 0) {
          for (int j = 0; j < epPatrolPointList.size(); j++) {
            // 判断是否是当前站层的巡查点
            if (epPatrolPointList.get(j).getLayerId().equals(list.get(i).getId())) {
              Map<String, Object> mapChildren = new LinkedHashMap<String, Object>();
              mapChildren.put("id", epPatrolPointList.get(j).getId());
	// 巡查点名称
              mapChildren.put("name", epPatrolPointList.get(j).getName());
	// x轴坐标
              mapChildren.put("coordinateX", epPatrolPointList.get(j).getCoordinateX());
	// y轴坐标
              mapChildren.put("coordinateY", epPatrolPointList.get(j).getCoordinateY());
	// 等级
              mapChildren.put("level", 6);
              mapChildren.put("pid", list.get(i).getId());
              mapChildren.put("layerId", list.get(i).getId());
              mapChildren.put("stationId", list.get(i).getStationId());
              mapChildren.put("filePath", list.get(i).getFilePath());
              mapChildren.put("readPath", list.get(i).getReadPath());
              mapChildren.put("byx2", epPatrolPointList.get(j).getByx2());
              childrenDic.add(mapChildren);
            }
          }
	// 把当前站层下所有的巡查点，绑定到站层上
          map.put("children", childrenDic);
        }
        if (childrenDic != null && childrenDic.size() > 0) {
	// 如果站层里有收藏的巡查点，把当前站层所有数据，加入树中
          nodes.add(map);
        }
      }
    }
    return R.ok().put("nodes", nodes);
  }

  /**
   * 添加
   *
   * @param bean 巡查点收藏夹对象 pointId 巡查点id
   * @return
   */
  @SysLog("添加巡查点收藏夹")
  @SysLogMethod(operation = "新增", blockName = "巡查点收藏夹", detail = "新增巡查点收藏夹数据")
  @ApiOperation(value = "新增巡查点收藏夹数据", notes = "新增巡查点收藏夹数据")
  @PostMapping("/save")
  public R save(
      @RequestBody @ApiParam(value = "巡查点收藏夹实体对象", required = true) EpPointEnshrine bean) {
    ValidatorUtils.validateEntity(bean);
    bean.setCreateUserId(getUserId());
    // 判断是否已收藏
    EpPointEnshrine byPointId = epPointEnshrineService.getByPointId(bean);
    if (byPointId != null) {
      return R.ok("已经收藏过了！");
    }
    bean.setCreateTime(new Date());
    bean.setSysSign(getUser().getSysSystem().getCode());
    epPointEnshrineService.save(bean);
    return R.ok("收藏成功");
  }

  /**
   * 根据ID删除巡查点收藏夹对象
   *
   * @param bean 巡查点收藏夹对象 pointId 巡查点id
   * @return
   */
  @SysLog("删除巡查点收藏夹")
  @SysLogMethod(operation = "删除", blockName = "巡查点收藏夹", detail = "删除巡查点收藏夹数据")
  @ApiOperation(value = "根据ID删除巡查点收藏夹数据", notes = "根据ID删除巡查点收藏夹数据")
  @PostMapping("/delete")
  public R delete(@RequestBody EpPointEnshrine bean) {
    epPointEnshrineService.remove(
        new QueryWrapper<EpPointEnshrine>().eq("point_id", bean.getPointId()));
    return R.ok();
  }
}
