package com.devplatform.equipment.modules.eppointenshrine.dao;

import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.eppointenshrine.bean.EpPointEnshrine;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

/**
 * EpPoinenshrine Mapper 用于巡查点收藏夹的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface EpPointEnshrineDao extends MyBaseMapper<EpPointEnshrine> {

  /**
   * 查询巡查点收藏夹数据
   * @param bean
   * @return
   */
  EpPointEnshrine getByPointId(EpPointEnshrine bean);

  /**
   * 删除收藏
   * @param bean
   */
  void deleteByPointId(EpPointEnshrine bean);

  /**
   * 查询收藏夹
   * @param createUserId
   * @param stationId
   * @return
   */
  List<EpPointEnshrine> getByCreateUserId(
      @Param("createUserId") String createUserId, @Param("stationId") String stationId);
}
