package com.devplatform.equipment.modules.ewarning.bean;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;

/**
 * @author Administrator
 */
public class BaseSocket {
  private SocketAddress socketAddress;

  public SocketAddress getSocketAddress() {
    return socketAddress;
  }

  public void setSocketAddress(SocketAddress socketAddress) {
    this.socketAddress = socketAddress;
  }

  public InetSocketAddress getInetSocketAddress() {
    return (InetSocketAddress) socketAddress;
  }

  public void setSocketAddress(String ip, int port) {
    try {
      socketAddress = new InetSocketAddress(InetAddress.getByName(ip), port);
    } catch (UnknownHostException e) {
    }
  }

  public String getRemoteAddr() {
    return getInetSocketAddress().getAddress().getHostAddress();
  }

  public int getRemotePort() {
    return getInetSocketAddress().getPort();
  }
}
