package com.devplatform.equipment.modules.ewarning.controller;

import com.alibaba.fastjson.JSONObject;
import com.devplatform.equipment.common.utils.AbstractController;
import com.devplatform.equipment.common.utils.Constants;
import com.devplatform.equipment.common.utils.TestClient;
import com.devplatform.equipment.common.utils.Utils;
import com.devplatform.equipment.modules.ewarning.bean.CameraPojo;
import com.devplatform.equipment.modules.liresource.model.LiResourceModel;
import com.devplatform.equipment.modules.liresource.service.LiResourceService;
import com.devplatform.equipment.modules.listation.bean.LiStation;
import com.devplatform.equipment.modules.listation.service.LiStationService;
import io.swagger.annotations.Api;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Title CameraController.java
 *
 * @description controller
 * @time 2020年3月16日 下午3:43:29
 * @author liyang
 */
@Api(tags = {"设备控制接口"})
@RestController
@RequestMapping("/camera")
public class CameraController extends AbstractController {

  private static final Logger logger = LoggerFactory.getLogger(CameraController.class);

  @Autowired private LiResourceService liResourceService;
  @Autowired private LiStationService liStationService;

  /**
   * @Title: openCamera @Description:开启视频流，进行本地保存并实现回放
   *
   * @param pojo
   * @return Map<String,String>
   */
  @RequestMapping(value = "/camerasBackPlay", method = RequestMethod.POST)
  public Map<String, Object> camerasBackPlay(@RequestBody CameraPojo pojo) {

    logger.info( "hcsdk 参数 设备信息：[ip:" + pojo.getIp() + " port:" + pojo.getPort() + " username:" + pojo.getUsername()
            + " password:" + pojo.getPassword() + " channel:" + pojo.getChannel() + " stream:" + pojo.getStream()
            + " statrtime:" + pojo.getStarttime() + " endtime:" + pojo.getEndtime() + "]");
    // 返回结果
    Map<String, Object> map = new LinkedHashMap<>();
    // openStream返回结果
    Map<String, Object> openMap = new HashMap<>(10);
    JSONObject cameraJson = JSONObject.parseObject(JSONObject.toJSON(pojo).toString());
    // 需要校验非空的参数
    String[] isNullArr = {"ip", "port", "username", "password", "channel", "stream"};
    // 空值校验
    if (!Utils.isNullParameters(cameraJson, isNullArr)) {
      map.put("msg", "输入参数不完整");
      map.put("code", 1);
      return map;
    }
    // ip格式校验
    if (!Utils.isTrueIp(pojo.getIp())) {
      map.put("msg", "ip格式输入错误");
      map.put("code", 2);
      return map;
    }
    if (null != pojo.getStarttime() || "".equals(pojo.getStarttime())) {
      // 开始时间校验
      if (!Utils.isTrueTime(pojo.getStarttime())) {
        map.put("msg", "starttime格式输入错误");
        map.put("code", 3);
        return map;
      }
      if (null != pojo.getEndtime() || "".equals(pojo.getEndtime())) {
        if (!Utils.isTrueTime(pojo.getEndtime())) {
          map.put("msg", "endtime格式输入错误");
          map.put("code", 4);
          return map;
        }
        // 结束时间要大于开始时间
        try {
          long starttime =
              new SimpleDateFormat("yyyy-MM-dd HH:ss:mm").parse(pojo.getStarttime()).getTime();
          long endtime =
              new SimpleDateFormat("yyyy-MM-dd HH:ss:mm").parse(pojo.getEndtime()).getTime();
          if (endtime - starttime < 0) {
            map.put("msg", "endtime需要大于starttime");
            map.put("code", 5);
            return map;
          }
        } catch (ParseException e) {
          logger.error(e.getMessage());
        }
      }
    }

    String postUrl = getUrl(pojo.getStationId());
    Map<String, String> postParam = new HashMap<String, String>(10);
    postParam.put("liResourceId", pojo.getResourceId());
    postParam.put("stationId", pojo.getStationId());
    postParam.put("params", "4");
    postParam.put("params2", pojo.getStarttime());
    postParam.put("params3", pojo.getEndtime());
    postParam.put("userId", pojo.getUserId());
    postParam.put("levelType", pojo.getLevelType() + "");
    postParam.put("controlType", pojo.getControlType() + "");
    Map<String, Object> resultMap = TestClient.uploadText(postUrl, postParam);

    if (Constants.STRING_200.equals(resultMap.get(Constants.STATUS_CODE).toString())) {
      map = JSONObject.parseObject(resultMap.get("data").toString(), Map.class);
    }
    if (!map.isEmpty() && Constants.STRING_0.equals(map.get(Constants.CODE_WORD).toString())) {
      // 云台控制操作，返回0为操作成功
      map.put("msg", "操作成功");
      map.put("url", map.get("url").toString());
    } else {
      map.put("code", 1);
      map.put("msg", map.get("msg").toString());
    }
    return map;
  }

  /**
   * @Title: openCamera @Description:云台控制，摄像头位置转动，调焦
   *
   * @param pojo
   * @return Map<String,String>
   */
  @RequestMapping(value = "/ptzControl", method = RequestMethod.POST)
  public Map<String, Object> ptzCamera(@RequestBody CameraPojo pojo) {
    String postUrl = getUrl(pojo.getStationId());
    //		String postUrl = "http://localhost:8089/command/operation";
    Map<String, String> postParam = new HashMap<String, String>(16);
    postParam.put("liResourceId", pojo.getResourceId());
    postParam.put("stationId", pojo.getStationId());
    postParam.put("params", "1");
    postParam.put("params2", pojo.getDwPtzCommand() + "");
    postParam.put("params3", pojo.getDwStop() + "");
    postParam.put("userId", pojo.getUserId());
    postParam.put("levelType", pojo.getLevelType() + "");
    postParam.put("controlType", pojo.getControlType() + "");
    Map<String, Object> resultMap = TestClient.uploadText(postUrl, postParam);
    Map<String, Object> map = new HashMap<>(16);
    if (Constants.STRING_200.equals(resultMap.get(Constants.STATUS_CODE).toString())) {
      map = JSONObject.parseObject(resultMap.get("data").toString(), Map.class);
    }
    // 云台控制操作，返回0为操作成功
    if (!map.isEmpty() && Constants.STRING_0.equals(map.get(Constants.CODE_WORD).toString())) {
      if (pojo.getDwPtzCommand() == Constants.INT_11) {
        map.put("msg", "焦距变大成功");
      } else if (pojo.getDwPtzCommand() == Constants.INT_12) {
        map.put("msg", "焦距变小成功");
      } else if (pojo.getDwPtzCommand() == Constants.INT_13) {
        map.put("msg", "焦点前调成功");
      } else if (pojo.getDwPtzCommand() == Constants.INT_14) {
        map.put("msg", "焦点后调成功");
      } else if (pojo.getDwPtzCommand() == Constants.INT_15) {
        map.put("msg", "光圈扩大成功");
      } else if (pojo.getDwPtzCommand() == Constants.INT_16) {
        map.put("msg", "光圈扩小成功");
      } else {
        map.put("msg", "云台控制成功");
      }
    } else {
      map.put("code", 1);
      if (pojo.getDwPtzCommand() == Constants.INT_11) {
        map.put("msg", "变倍调大失败，请确认设备是否支持或网络是否正常");
      } else if (pojo.getDwPtzCommand() == Constants.INT_12) {
        map.put("msg", "变倍调小失败，请确认设备是否支持或网络是否正常");
      } else if (pojo.getDwPtzCommand() == Constants.INT_13) {
        map.put("msg", "焦点前调失败，请确认设备是否支持或网络是否正常");
      } else if (pojo.getDwPtzCommand() == Constants.INT_14) {
        map.put("msg", "焦点后调失败，请确认设备是否支持或网络是否正常");
      } else if (pojo.getDwPtzCommand() == Constants.INT_15) {
        map.put("msg", "光圈扩大失败，请确认设备是否支持或网络是否正常");
      } else if (pojo.getDwPtzCommand() == Constants.INT_16) {
        map.put("msg", "光圈扩小失败，请确认设备是否支持或网络是否正常");
      } else {
        map.put("msg", "控制操作失败，请确认设备是否支持或网络是否正常");
      }
    }
    return map;
  }

  /**
   * @Title: openCamera @Description:云台控制，1、预置点位置设置，2、预置点位置调用转向
   *
   * @param pojo
   * @return Map<String,String>
   */
  @RequestMapping(value = "/presetControl", method = RequestMethod.POST)
  public Map<String, Object> presetControl(@RequestBody CameraPojo pojo) {
    String postUrl = getUrl(pojo.getStationId());
    //		String postUrl = "http://localhost:8089/command/operation";
    Map<String, String> postParam = new HashMap<String, String>(16);
    postParam.put("liResourceId", pojo.getResourceId());
    postParam.put("stationId", pojo.getStationId());
    postParam.put("params", "1");
    postParam.put("params2", pojo.getDwPtzCommand() + "");
    postParam.put("params3", pojo.getPreset() + "");
    postParam.put("userId", pojo.getUserId());
    postParam.put("levelType", pojo.getLevelType() + "");
    postParam.put("controlType", pojo.getControlType() + "");
    Map<String, Object> resultMap = TestClient.uploadText(postUrl, postParam);
    Map<String, Object> map = new HashMap<>(16);
    if (Constants.STRING_200.equals(resultMap.get(Constants.STATUS_CODE).toString())) {
      map = JSONObject.parseObject(resultMap.get("data").toString(), Map.class);
    }
    // 云台控制操作，返回0为操作成功
    if (!map.isEmpty() && Constants.STRING_0.equals(map.get(Constants.CODE_WORD).toString())) {
      map.put("msg", "操作成功");
    } else {
      map.put("code", 1);
      map.put("msg", "控制操作失败，请确认设备是否支持或网络是否正常");
    }
    return map;
  }

  /**
   * @Title: 安检机皮带控制 @Description:控制参数,1=停止,2=正转，3=反转
   *
   * @param model
   * @return Map<String,String>
   */
  @RequestMapping(value = "/inspectTurn", method = RequestMethod.POST)
  public Map<String, Object> inspectTurn(@RequestBody LiResourceModel model) {
    String postUrl = getUrl(model.getStationId());
    //		String postUrl = "http://localhost:8089/command/operation";
    Map<String, String> postParam = new HashMap<String, String>(16);
    postParam.put("liResourceId", model.getId());
    postParam.put("stationId", model.getStationId());
    postParam.put("params", model.getValueInfo());
    postParam.put("paramsName", model.getActionName());
    postParam.put("userId", model.getUserId());
    postParam.put("levelType", model.getLevelType() + "");
    postParam.put("controlType", model.getControlType() + "");
    Map<String, Object> resultMap = TestClient.uploadText(postUrl, postParam);
    Map<String, Object> map = null;
    if (Constants.STRING_200.equals(resultMap.get(Constants.STATUS_CODE).toString())) {
      map = JSONObject.parseObject(resultMap.get("data").toString(), Map.class);
    }
    return map;
  }

  /**
   * @Title: 照明灯开关控制 @Description:控制参数,0=关，1=开
   *
   * @param model
   * @return Map<String,String>
   */
  @RequestMapping(value = "/lightingOnOff", method = RequestMethod.POST)
  public Map<String, Object> lightingOnOff(@RequestBody LiResourceModel model) {
    String postUrl = getUrl(model.getStationId());
    //		String postUrl = "http://localhost:8089/command/operation";
    Map<String, String> postParam = new HashMap<String, String>(10);
    postParam.put("liResourceId", model.getId());
    postParam.put("stationId", model.getStationId());
    postParam.put("params", model.getValueInfo());
    postParam.put("paramsName", model.getActionName());
    postParam.put("userId", model.getUserId());
    postParam.put("levelType", model.getLevelType() + "");
    postParam.put("controlType", model.getControlType() + "");
    Map<String, Object> resultMap = TestClient.uploadText(postUrl, postParam);
    Map<String, Object> map = null;
    if (Constants.STRING_200.equals(resultMap.get(Constants.STATUS_CODE).toString())) {
      map = JSONObject.parseObject(resultMap.get("data").toString(), Map.class);
    }
    return map;
  }

  /**
   * @Title: 视频直播 @Description: 打开直播
   *
   * @param model
   * @return Map<String,String>
   */
  @RequestMapping(value = "/camerasPlay", method = RequestMethod.POST)
  public Map<String, Object> camerasPlay(@RequestBody LiResourceModel model) {
    String postUrl = getUrl(model.getStationId());
    //		String postUrl = "http://localhost:8089/command/operation";
    Map<String, String> postParam = new HashMap<String, String>(10);
    postParam.put("liResourceId", model.getId());
    postParam.put("stationId", model.getStationId());
    postParam.put("params", "5");
    postParam.put("userId", model.getUserId());
    postParam.put("levelType", model.getLevelType() + "");
    postParam.put("controlType", model.getControlType() + "");
    Map<String, Object> resultMap = TestClient.uploadText(postUrl, postParam);
    Map<String, Object> map = null;
    if (Constants.STRING_200.equals(resultMap.get(Constants.STATUS_CODE).toString())) {
      map = JSONObject.parseObject(resultMap.get("data").toString(), Map.class);
    }
    return map;
  }

  /**
   * @Title: 门禁开关控制 @Description:控制参数,0=开，1=关
   *
   * @param model
   * @return Map<String,String>
   */
  @RequestMapping(value = "/doorOnOff", method = RequestMethod.POST)
  public Map<String, Object> doorOnOff(@RequestBody LiResourceModel model) {
    String postUrl = getUrl(model.getStationId());
    //		String postUrl = "http://localhost:8089/command/operation";
    Map<String, String> postParam = new HashMap<String, String>(10);
    postParam.put("liResourceId", model.getId());
    postParam.put("params", model.getValueInfo());
    postParam.put("paramsName", model.getActionName());
    postParam.put("userId", model.getUserId());
    postParam.put("levelType", model.getLevelType() + "");
    postParam.put("controlType", model.getControlType() + "");
    Map<String, Object> resultMap = TestClient.uploadText(postUrl, postParam);
    Map<String, Object> map = null;
    if (Constants.STRING_200.equals(resultMap.get(Constants.STATUS_CODE).toString())) {
      map = JSONObject.parseObject(resultMap.get("data").toString(), Map.class);
    }
    return map;
  }

  private String getUrl(String stationId) {
    LiStation liStation = liStationService.getById(stationId);
    return liStation.getByx1();
  }
}
