package com.devplatform.equipment.modules.ewarning.controller;

import com.devplatform.common.base.annotation.SysLog;
import com.devplatform.common.util.R;
import com.devplatform.common.util.StringUtil;
import com.devplatform.equipment.common.utils.AbstractController;
import com.devplatform.equipment.common.utils.Constants;
import com.devplatform.equipment.modules.ewarning.service.EwarningService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/** @author */
@Api(tags = {"报警信息表接口"})
@RestController
@RequestMapping("/eWarning")
public class EwarningController extends AbstractController {
  @Autowired private EwarningService ewarningService;

  /**
   * 根据ID批量处理报警信息表数据
   *
   * @param ids 报警信息表对象主键数组
   * @return
   */
  @SysLog("处理报警信息表")
  @ApiOperation(value = "根据ID批量处理报警信息表数据", notes = "根据ID批量处理报警信息表数据")
  @ApiImplicitParam(name = "ids", value = "主键数组", required = true, dataType = "String")
  @PostMapping("/dealWith")
  public R dealWith(@RequestParam String ids) {
    ewarningService.dealWithBatch(Arrays.asList(ids.split(",")));
    return R.ok();
  }

  /** 接收软网关 */
  @ApiOperation(value = "接收软网关", notes = "接收软网关")
  @PostMapping("/getControlResultsInfo")
  public int getControlResultsInfo() {
    return 0;
  }

  @GetMapping("/getActionByType")
  public R getActionByType(String subCode, String resourceType, String brand, String stationId) {
    Map<String, Object> map = null;
    if (StringUtil.isNotEmpty(resourceType)) {
      map = ewarningService.getActionByType(subCode, resourceType, brand, stationId);
    } else {
      map =
          ewarningService.getActionByType(
              subCode, Constants.LI_RESOURCE_TYPE_AJJ, brand, stationId);
    }
    return R.ok().put("map", map);
  }
}
