package com.devplatform.equipment.modules.ewarning.dao;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.ewarning.bean.Ewarning;
import com.devplatform.equipment.modules.ewarning.model.EwarningModel;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import javax.swing.text.html.ObjectView;

/**
 * EWarning Mapper 用于报警信息表的数据库操作
 *
 * @author Administrator
 */
@Mapper
public interface EwarningDao extends MyBaseMapper<Ewarning> {
  /**
   * 查询报警信息
   * @param page
   * @param model
   * @return
   */
  Page<Ewarning> queryPageList(
      @Param("page") Page<Ewarning> page, @Param("model") EwarningModel model);

  /**
   * 批量删除
   * @param ids
   */
  void deleteBatch(@Param("ids") List<String> ids);

  /**
   * 批量处理
   * @param ids
   */
  void dealWithBatch(@Param("ids") List<String> ids);

  /**
   * 通过资源类型查找动作
   *
   * @param subCode
   * @param resourceType
   * @param brand
   * @param stationId
   * @return
   */
  Map<String, Object> getActionByType(
      @Param("subCode") String subCode,
      @Param("resourceType") String resourceType,
      @Param("brand") String brand,
      @Param("stationId") String stationId);

  /**
   * 通过动作id查找动作指令
   *
   * @param subCode
   * @param resourceType
   * @param brand
   * @param stationId
   * @param actionId
   * @return
   */
  Map<String, Object> getOneEqTypeInfo(
      @Param("subCode") String subCode,
      @Param("resourceType") String resourceType,
      @Param("brand") String brand,
      @Param("stationId") String stationId,
      @Param("actionId") String actionId);

  /**
   * 查询报警级别
   * @param stationId
   * @return
   */
  Integer queryLevel(@Param("stationId")String stationId);

  /**
   * 查询默认连接
   * @param stationId
   * @return
   */
  Map<String, Object> getOneArUpConfig(@Param("stationId")String stationId);
}
