package com.devplatform.equipment.modules.ewarning.service;

import com.devplatform.common.service.MyBaseService;
import com.devplatform.equipment.modules.ewarning.bean.CameraPojo;
import com.devplatform.equipment.modules.ewarning.bean.Ewarning;
import java.util.List;
import java.util.Map;

/**
 * 报警信息表的service接口 <br>
 * <b>功能：</b>EWarningService<br>
 *
 * @author 代码生成器产生
 */
public interface EwarningService extends MyBaseService<Ewarning> {

  /**
   * 批量删除
   * @param ids
   */
  void deleteBatch(List<String> ids);

  /**
   * 批量处理
   * @param ids
   */
  void dealWithBatch(List<String> ids);

  /**
   * 云台控制，1、预置点位置设置，2、预置点位置调用转向 @Title: openCamera
   *
   * @param pojo
   * @return Map<String,String>
   */
  Map<String, Object> presetControl(CameraPojo pojo);

  /**
   * 照明灯和声光报警器开关控制
   * @param actionId
   * @param subCode
   * @param brand
   * @param resourceId
   * @param type
   * @param action
   * @param stationId
   * @param userId
   * @param levelType
   * @param controlType
   * @return
   */
  Map<String, Object> lightingOnOff(
      String actionId,
      String subCode,
      String brand,
      String resourceId,
      String type,
      String action,
      String stationId,
      String userId,
      String levelType,
      String controlType);

  /**
   * 摄像头拍照
   *
   * @param pojo
   * @return
   */
  Map<String, Object> captureJpegPictureCamera(CameraPojo pojo);

  /**
   * 摄像头录像
   *
   * @param pojo
   * @return
   */
  Map<String, Object> videoDowload(CameraPojo pojo);

  /**
   * 处理黑名单报警
   *
   * @param info
   */
  //    void handleAlarmsInfo(JosnInfo info);

  /**
   * 处理报警信息
   *
   * @param message
   */
  void handleAlarmsInfo(String message);

  /**
   * 通过资源类型查找动作
   *
   * @param subCode
   * @param resourceType
   * @param brand
   * @param stationId
   * @return
   */
  Map<String, Object> getActionByType(
      String subCode, String resourceType, String brand, String stationId);

  /**
   * 判断是否接收消息
   * @param stationId
   * @return
   */
  Boolean isResMsg(String stationId);

  /**
   * 查询默认连接
   * @param stationId
   * @return
   */
  Map<String, Object> getOneArUpConfig(String stationId);

  /**
   * 初始化MQ
   * @param stationId
   */
  void initMq(String stationId);
}
