package com.devplatform.equipment.modules.ewarning.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.devplatform.common.service.impl.MyBaseServiceImpl;
import com.devplatform.common.util.StringUtil;
import com.devplatform.equipment.common.utils.*;
import com.devplatform.equipment.feign.service.AdminService;
import com.devplatform.equipment.feign.service.AlarmsService;
import com.devplatform.equipment.modules.alarms.bean.AlarmsInfo;
import com.devplatform.equipment.modules.alarms.model.AlarmsInfoModel;
import com.devplatform.equipment.modules.alarms.service.AlarmsInfoService;
import com.devplatform.equipment.modules.ewarning.bean.CameraPojo;
import com.devplatform.equipment.modules.ewarning.bean.Ewarning;
import com.devplatform.equipment.modules.ewarning.dao.EwarningDao;
import com.devplatform.equipment.modules.ewarning.service.EwarningService;
import com.devplatform.equipment.modules.liresource.bean.LiResource;
import com.devplatform.equipment.modules.liresource.service.LiResourceService;
import com.devplatform.equipment.modules.listation.bean.LiStation;
import com.devplatform.equipment.modules.listation.service.LiStationService;
import com.devplatform.equipment.modules.link.log.bean.LinkAttachment;
import com.devplatform.equipment.modules.link.log.bean.LinkLogs;
import com.devplatform.equipment.modules.link.log.bean.LinkLogsAction;
import com.devplatform.equipment.modules.link.log.service.LinkAttachmentService;
import com.devplatform.equipment.modules.link.log.service.LinkLogsActionService;
import com.devplatform.equipment.modules.link.log.service.LinkLogsService;
import com.devplatform.equipment.modules.link.service.LinkLinkageRuleService;
import com.devplatform.equipment.modules.orgate.bean.OrGate;
import com.devplatform.equipment.modules.orgate.service.OrGateService;
import com.devplatform.equipment.modules.orintrude.bean.OrIntrude;
import com.devplatform.equipment.modules.orintrude.service.OrIntrudeService;
import com.devplatform.equipment.modules.orsafetycheck.bean.OrSafetyCheck;
import com.devplatform.equipment.modules.orsafetycheck.service.OrSafetyCheckService;
import com.devplatform.equipment.modules.orvideomonitor.bean.OrVideoMonitor;
import com.devplatform.equipment.modules.orvideomonitor.service.OrVideoMonitorService;
import com.devplatform.equipment.modules.sys.bean.SysSystem;
import com.devplatform.equipment.modules.sys.service.SysSystemService;
import com.devplatform.equipment.modules.sysdictionary.service.SysDictionaryService;
import com.devplatform.equipment.modules.syspreset.bean.SysPreset;
import com.devplatform.equipment.modules.syspreset.service.SysPresetService;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/**
 * 报警信息表的service接口实现类 <br>
 * <b>功能：</b>EWarningServiceImpl<br>
 *
 * @author 代码生成器产生
 */
@Service("eWarningService")
public class EwarningServiceImpl extends MyBaseServiceImpl<EwarningDao, Ewarning>
    implements EwarningService {
  @Autowired private OrVideoMonitorService orVideoMonitorService;
  @Autowired private OrGateService orGateService;
  @Autowired private OrIntrudeService orIntrudeService;
  @Autowired private OrSafetyCheckService orSafetyCheckService;
  @Autowired private SysPresetService sysPresetService;
  @Autowired private AlarmsInfoService alarmsInfoService;

  @Autowired private AdminService adminService;

  @Autowired private LinkLinkageRuleService linkLinkageRuleService;

  @Autowired private LinkLogsService linkLogsService;

  @Autowired private LinkLogsActionService linkLogsActionService;

  @Autowired private LinkAttachmentService linkAttachmentService;

  @Autowired private AlarmsService alarmsService;

  @Autowired private LiResourceService liResourceService;

  @Autowired private SysSystemService sysSystemService;

  @Autowired private LiStationService liStationService;

  @Autowired private SysDictionaryService sysDictionaryService;

  @Value("${upload.realBaseDir}")
  private String realBaseDir;

  @Value("${spring.rabbitmq.host}")
  private String host;
  @Value("${spring.rabbitmq.username}")
  private String username;
  @Value("${spring.rabbitmq.password}")
  private String password;
  @Value("${spring.rabbitmq.port}")
  private int port;
  @Value("${spring.rabbitmq.virtual-host}")
  private String virtualHost;

  @Override
  public void deleteBatch(List<String> ids) {
    baseMapper.deleteBatch(ids);
  }

  @Override
  public void dealWithBatch(List<String> ids) {
    baseMapper.dealWithBatch(ids);
  }

  /**
   * @param pojo
   * @return Map<String , String> @Title: openCamera @Description:云台控制，1、预置点位置设置，2、预置点位置调用转向
   */
  @Override
  public Map<String, Object> presetControl(CameraPojo pojo) {
    String postUrl = getUrl(pojo.getStationId());
    //        String postUrl = "http://localhost:8089/command/operation";
    Map<String, String> postParam = new HashMap<String, String>(10);
    postParam.put("liResourceId", pojo.getResourceId());
    postParam.put("stationId", pojo.getStationId());
    postParam.put("params", "1");
    postParam.put("params2", pojo.getDwPtzCommand() + "");
    postParam.put("params3", pojo.getPreset() + "");
    postParam.put("userId", pojo.getUserId());
    postParam.put("levelType", pojo.getLevelType() + "");
    postParam.put("controlType", pojo.getControlType() + "");
    Map<String, Object> resultMap = TestClient.uploadText(postUrl, postParam);
    Map<String, Object> map = new HashMap<>(2);
    if (Constants.STRING_200.equals(resultMap.get(Constants.STATUS_CODE).toString())) {
      map = JSONObject.parseObject(resultMap.get("data").toString(), Map.class);
    }
    return map;
  }

  /**
   * @Title: 照明灯、声光报警灯、门禁
   *
   * @param resourceId 当前资源点id
   * @param type 资源点类型
   * @param action 动作名称
   * @return Map<String,String>
   */
  @Override
  public Map<String, Object> lightingOnOff(
      String actionId,
      String subCode,
      String brand,
      String resourceId,
      String type,
      String action,
      String stationId,
      String userId,
      String levelType,
      String controlType) {
    String postUrl = getUrl(stationId);
    //        String postUrl = "http://localhost:8089/command/operation";
    Map<String, String> postParam = new HashMap<String, String>(5);
    postParam.put("liResourceId", resourceId);
    postParam.put("stationId", stationId);
    Map<String, Object> map = null;
    Map<String, Object> eqTypeInfo =
        baseMapper.getOneEqTypeInfo(subCode, type, brand, stationId, actionId);
    if (eqTypeInfo.isEmpty()) {
      map.put("code", 1);
      map.put("msg", "软网关未维护该设备的信号指令值");
      return map;
    }

    postParam.put("params", eqTypeInfo.get("value_info").toString());
    postParam.put("paramsName", eqTypeInfo.get("actionName").toString());
    postParam.put("userId", userId);
    postParam.put("levelType", levelType);
    postParam.put("controlType", controlType);
    Map<String, Object> resultMap = TestClient.uploadText(postUrl, postParam);

    if (Constants.STRING_200.equals(resultMap.get(Constants.STATUS_CODE).toString())) {
      map = JSONObject.parseObject(resultMap.get("data").toString(), Map.class);
    }
    return map;
  }

  private String getUrl(String stationId) {
    LiStation liStation = liStationService.getById(stationId);
    return liStation.getByx1();
  }

  /**
   * 云台控制，摄像头拍照
   *
   * @param pojo
   * @return
   */
  @Override
  public Map<String, Object> captureJpegPictureCamera(CameraPojo pojo) {
    String postUrl = getUrl(pojo.getStationId());
    //        String postUrl = "http://localhost:8089/command/operation";
    Map<String, String> postParam = new HashMap<String, String>(10);
    postParam.put("liResourceId", pojo.getResourceId());
    postParam.put("stationId", pojo.getStationId());
    postParam.put("params", "2");
    postParam.put("params2", pojo.getParamsValue1());
    postParam.put("params3", pojo.getParamsValue2());
    postParam.put("userId", pojo.getUserId());
    postParam.put("levelType", pojo.getLevelType() + "");
    postParam.put("controlType", pojo.getControlType() + "");
    Map<String, Object> resultMap = TestClient.uploadText(postUrl, postParam);
    Map<String, Object> map = new HashMap<>(5);
    if (Constants.STRING_200.equals(resultMap.get(Constants.STATUS_CODE).toString())) {
      map = JSONObject.parseObject(resultMap.get("data").toString(), Map.class);
    }
    return map;
  }

  /**
   * 云台控制，摄像头录像
   *
   * @param pojo
   * @return
   */
  @Override
  public Map<String, Object> videoDowload(CameraPojo pojo) {
    String postUrl = getUrl(pojo.getStationId());
    //        String postUrl = "http://localhost:8089/command/operation";
    Map<String, String> postParam = new HashMap<String, String>(10);
    postParam.put("liResourceId", pojo.getResourceId());
    postParam.put("stationId", pojo.getStationId());
    postParam.put("params", "3");
    postParam.put("params2", pojo.getParamsValue1());
    postParam.put("params3", pojo.getParamsValue2());
    postParam.put("userId", pojo.getUserId());
    postParam.put("levelType", pojo.getLevelType() + "");
    postParam.put("controlType", pojo.getControlType() + "");
    Map<String, Object> resultMap = TestClient.uploadText(postUrl, postParam);
    Map<String, Object> map = new HashMap<>(5);
    if (Constants.STRING_200.equals(resultMap.get(Constants.STATUS_CODE).toString())) {
      map = JSONObject.parseObject(resultMap.get("data").toString(), Map.class);
    }
    return map;
  }

  @Override
  public void handleAlarmsInfo(String message) {
    System.out.println("开始处理报警信息" + message);
    Map<String, Object> resultMap = new HashMap<>(5);
    try {
      resultMap = JSONObject.parseObject(message, Map.class);
      if (resultMap != null && resultMap.isEmpty()) {
        return;
      }
      SysSystem sysSystem = sysSystemService.getById(Constants.STRING_1);

      AlarmsInfo bean = createAlarmsInfo(resultMap,sysSystem.getCode());
      if (bean == null) {
        return;
      }
      String eventType = resultMap.get("eventType") == null ? "" : (String) resultMap.get("eventType");
      // 发送webSocket消息提醒
      this.sendMessage(bean.getId(), bean.getStationId(), eventType,bean.getLineId());

      // 调用规则
      String resourceId = bean.getResourceId();
      String alarmsId = bean.getId();
      Date time = new Date();

      List<HashMap<String, Object>> linkRule = linkLinkageRuleService.getLinkRule(resourceId, bean.getStationId());
      if (linkRule == null || linkRule.size() == 0) {
        return;
      }

      // 执行联动规则
      // 只会找到一条规则
      HashMap<String, Object> link = linkRule.get(0);
      LinkLogs linkLogs = new LinkLogs();
      linkLogs.setRuleActionId(link.get("id").toString());
      linkLogs.setAlarmsInfoId(alarmsId);
      // 默认是系统执行
      linkLogs.setCreateUserId("0");
      linkLogs.setCreateTime(time);
      linkLogs.setStationId(bean.getStationId());
      linkLogs.setSysSign(sysSystem.getCode());
      linkLogsService.save(linkLogs);

      ThreadPool.init();
      calcAction(link,linkLogs.getId(),sysSystem.getCode(),alarmsId,resourceId,eventType,time,bean.getLineId());

      if (link.get(Constants.EXECUTION_MODE) != null && Constants.STRING_2.equals(link.get(Constants.EXECUTION_MODE).toString())) {
        ThreadPool.threadPoolExecutor.shutdown();
	// 等待所有任务都执行结束
        while (true) {
	// 所有的子线程都结束了
          if (ThreadPool.threadPoolExecutor.isTerminated()) {
            // 发送webSocket消息提醒
            System.out.println("子线程全部结束");
            this.sendMessage(alarmsId, bean.getStationId(), eventType,bean.getLineId());
            break;
          }
        }
      } else {
        // 发送webSocket消息提醒
        this.sendMessage(alarmsId, bean.getStationId(), eventType,bean.getLineId());
      }
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void calcAction(HashMap<String, Object> link,String logId,String sysSign,String alarmsId,String resourceId,String eventType,Date time,String lineId){
    try {
      ArrayList<HashMap<String, Object>> actions = (ArrayList<HashMap<String, Object>>) link.get("actions");
      for (HashMap<String, Object> action : actions) {
        String ruleActionId = (String) action.get("id");
        String actionId = (String) action.get("actionId");
        String actionInfo = (String) action.get("actionInfo");
        String resourceName = (String) action.get("resourceName");
        String actionResourceId = (String) action.get("resourceId");
        String deployLocation = (String) action.get("deployLocation");
        String subCode = (String) action.get("subCode");
        String stationId = (String) action.get("stationId");
        String typeName = (String) action.get("typeName");
        String type = (String) action.get("type");
        String lineStationName = (String) action.get("lineStationName");
        String paramsName1 = (String) action.get("paramsName1");
        String paramsName2 = (String) action.get("paramsName2");
        String paramsValue1 = (String) action.get("paramsValue1");
        String paramsValue2 = (String) action.get("paramsValue2");
        String addressCode = (String) action.get("addressCode");
        String port = (String) action.get("port");
        String username = (String) action.get("username");
        String password = (String) action.get("password");
        String brand = (String) action.get("brand");
        String channel = (String) action.get("channel");

        if (link.get(Constants.EXECUTION_MODE) != null && Constants.STRING_2.equals(link.get(Constants.EXECUTION_MODE).toString())) {
          if ("c788ce98c1f248f590434394da485ce4".equals(type) || "b45827c068254695864ee3c1d42573cb".equals(type)) {
            // 照明灯/声光报警器
            // 执行动作
            Map<String, Object> map = this.executeAction(actionId,subCode,brand,stationId,actionResourceId,type,actionInfo,
                    paramsName1,paramsValue1,paramsName2,paramsValue2,addressCode,port,username,password,channel,time);

            // 写入指令
            insertIntrude(sysSign,ruleActionId,alarmsId,actionResourceId,resourceName,subCode,stationId,typeName,
                    lineStationName,actionInfo,"0".equals(map.get("code").toString())? 1: "2".equals(map.get("code").toString()) ? 3 : 2);
            // 写入联动日志
            this.saveLinkLogsAction(logId,action.get("id").toString(),"部署在" + deployLocation + "的" + typeName + "：" + resourceName + "执行了" + actionInfo,
                    "0".equals(map.get("code").toString()) ? 1 : "2".equals(map.get("code").toString()) ? 3 : 2,link,action,map,sysSign,stationId);
          } else {
            ThreadPool.threadPoolExecutor.execute(() -> {
              Map<String, Object> map = new HashMap<>(10);
              try {
                // 执行动作
                map = this.executeAction(actionId,subCode,brand,stationId,actionResourceId,type,actionInfo,paramsName1,paramsValue1,paramsName2,paramsValue2,addressCode,port,username,password,channel,time);
                insertIntrude(sysSign,ruleActionId,alarmsId,actionResourceId,resourceName,subCode,stationId,typeName,lineStationName,actionInfo,"0".equals(map.get("code").toString())? 1: "2".equals(map.get("code").toString()) ? 3 : 2);
              } catch (Exception e) {
                e.printStackTrace();
              }

              // 写入联动日志
              this.saveLinkLogsAction(logId,action.get("id").toString(),"部署在"+ deployLocation+ "的"+ typeName+ "："+ resourceName+ "执行了"+ actionInfo,"0".equals(map.get("code").toString()) ? 1 : "2".equals(map.get("code").toString()) ? 3 : 2,link,action,map,sysSign,stationId);
            });
          }
        } else {
          // 顺序执行
          // 执行动作
          Map<String, Object> map = this.executeAction(actionId,subCode,brand,stationId,actionResourceId,type,actionInfo,
                  paramsName1,paramsValue1,paramsName2,paramsValue2,addressCode,port,username,password,channel,time);

          // 写入指令
          insertIntrude(sysSign,ruleActionId,alarmsId,actionResourceId,resourceName,subCode,stationId,typeName,
                  lineStationName,actionInfo,"0".equals(map.get("code").toString())? 1: "2".equals(map.get("code").toString()) ? 3 : 2);
          // 写入联动日志
          this.saveLinkLogsAction(logId,action.get("id").toString(),"部署在" + deployLocation + "的" + typeName + "：" + resourceName + "执行了" + actionInfo,"0".equals(map.get("code").toString()) ? 1 : "2".equals(map.get("code").toString()) ? 3 : 2,link,action,map,sysSign,stationId);
        }
        if (actionInfo.indexOf("录像") == 0 || actionInfo.indexOf("拍照") == 0) {
          this.sendMessage(alarmsId, stationId, eventType,lineId);
        }
      }
    }catch (Exception e){
      e.printStackTrace();
    }
  }

  private AlarmsInfo createAlarmsInfo(Map<String, Object> map,String sysSign) {
    System.out.println("开始处理报警信息数据");
    String eventId = map.get("eventId") == null ? "" : (String) map.get("eventId");
    String eventName = map.get("eventName") == null ? "" : (String) map.get("eventName");
    String eventCode = map.get("eventCode") == null ? "" : (String) map.get("eventCode");
    String stationId = map.get("stationId") == null ? "" : (String) map.get("stationId");
    String resourceId = map.get("resourceId") == null ? "" : (String) map.get("resourceId");
    Integer eventLevel = map.get("eventLevel") == null ? null : (Integer) map.get("eventLevel");
    String eventType = map.get("eventType") == null ? "" : (String) map.get("eventType");
    LiResource liResource =liResourceService.getBeanById(resourceId);
    if (liResource == null) {
      return null;
    }
    String orderNum = liResourceService.getOrderNumByResId(resourceId);
    if (StringUtils.isBlank(orderNum)) {
      orderNum = "0";
    }
	// 黑名单报警
    if (Constants.STRING_2.equals(eventType)) {
      Map<String, Object> map1 = new HashMap<>(10);
      map1.put("status", 1);
      Date d = DateUtils.addSeconds(new Date(), -10);
      String tm = DateUtil.getPlusTime(d);
      System.out.println("startTime:" + tm);
      map1.put("startTime", tm);
      map1.put("stationId", stationId);
      map1.put("resourceId", resourceId);
      Integer num = alarmsInfoService.cNum(map1);
      if (num > 0) {
        return null;
      }
	// 炸探报警
    } else if (Constants.STRING_3.equals(eventType)) {
      String type = map.get("type") == null ? "" : (String) map.get("type");
      AlarmsInfoModel model = new AlarmsInfoModel();
      model.setEventType(eventType);
      AlarmsInfo lastInfo = alarmsInfoService.queryBsZt(model);
      if (Constants.STRING_1.equals(type)) {
        // 给上一条报警数据加标识 查询最新的一条炸探数据
        if (lastInfo != null && !Constants.STRING_1.equals(lastInfo.getByx2())) {lastInfo.setByx2(Constants.STRING_1);
          alarmsInfoService.update(lastInfo, new QueryWrapper<AlarmsInfo>().eq("id", lastInfo.getId()));
        }
      } else if (Constants.STRING_3.equals(type)) {
        // 如果无标识，不生成报警数据
        if (lastInfo != null && StringUtil.isEmpty(lastInfo.getByx2())) {
          return null;
        }
      }
    } else {
      if (liResource != null) {
        // 布防状态(0=撤防，1=布防-默认)  如果当前资源点为撤防状态，则不新增报警信息
        if (Constants.STRING_0.equals(liResource.getByx3())) {
          return null;
        }
      }
    }
    AlarmsInfo bean = createAlarmsInfo(liResource.getTierName(),eventCode,orderNum,liResource.getSubCode(),stationId,eventName,eventId,eventLevel,resourceId,liResource.getName(),liResource.getDeployLocation(),sysSign);
    if (Constants.STRING_2.equals(eventType)) {
      String libId = (String) map.get("libId");
      String imgId = (String) map.get("imgId");
      String snapId = (String) map.get("snapId");

      String pathStr = "upload/" + stationId + "/hmdbj/" + DateUtil.dateToString(new Date(), "yyyymm") + "/";
      createFile(realBaseDir + pathStr);
      String imagePath = "";
      String imageUuid = UUID.randomUUID() + ".jpg";
      imagePath = realBaseDir + pathStr + imageUuid;
      String imageUrl = "http://10.20.72.47:12345/img/" + libId + "_" + imgId + ".jpg";
      downloadPicture(imageUrl, imagePath);
      ftpFile(pathStr,imageUuid);

      String snapPath = "";
      String snapUuid = UUID.randomUUID() + ".jpg";
      snapPath = realBaseDir + pathStr + snapUuid;
      String snapUrl = "http://10.20.72.47:12345/record/" + snapId + ".jpg";
      downloadPicture(snapUrl, snapPath);
      ftpFile(pathStr,snapUuid);
      alarmsService.saveAttachment(imageUuid,pathStr + imageUuid,snapUuid,pathStr + snapUuid,bean.getId(),sysSign,stationId);
    }

    bean.setLineId(liResource.getLineId());
    return bean;
  }

  private AlarmsInfo createAlarmsInfo(String tierName,String eventCode,String orderNum,String subCode,String stationId,String eventName,String eventId,Integer eventLevel,
        String resourceId,String resourceName,String deployLocation,String sysSign){
    AlarmsInfo bean = new AlarmsInfo();
    bean.setId(UUID.randomUUID().toString().replaceAll("-", ""));
    // 事件类型编号 + 报警地点编号或代号 + 报警设备编号（含设备类型代码） + 报警发生时间
    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    bean.setEventNumber(eventCode + orderNum + "YT001" + sdf.format(new Date()));
    String systemId = sysDictionaryService.querySubId(subCode, stationId);
    bean.setSystemId(systemId);
    //层级名称+当前资源点部署位置+报警类型名称
    bean.setEventName(tierName + deployLocation + eventName);
    bean.setEventType(eventId);
    bean.setEventLevel(eventLevel);
    bean.setResourceId(resourceId);
    bean.setResourceName(resourceName);
    bean.setOccurrenceTime(new Date());
    bean.setOccurrenceSite(deployLocation);
    bean.setStatus(1);
    bean.setCreateUserId("0");
    bean.setCreateTime(new Date());
    bean.setUpdateUserId("0");
    bean.setUpdateTime(new Date());
    bean.setSysSign(sysSign);
    bean.setStationId(stationId);
    alarmsInfoService.save(bean);
    return bean;
  }

  private void createFile(String path){
    File baseFile = new File(path);
    try {
      if (!baseFile.exists()) {
        baseFile.mkdirs();
      }
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void ftpFile(String pathStr,String uuid){
    //Ftp上传文件到线路和线网
    try {
      // 执行推流任务
      FtpUploadThread t = new FtpUploadThread(realBaseDir, pathStr, uuid);
      t.start();
    } catch ( Exception e) {
      e.printStackTrace();
    }
  }

  /**
   * 链接url下载图片
   *
   * @param imageUrl
   * @param path
   */
  private void downloadPicture(String imageUrl, String path) {
    URL url = null;
    try {
      url = new URL(imageUrl);
      DataInputStream dataInputStream = new DataInputStream(url.openStream());

      FileOutputStream fileOutputStream = new FileOutputStream(new File(path));
      ByteArrayOutputStream output = new ByteArrayOutputStream();

      byte[] buffer = new byte[1024];
      int length;

      while ((length = dataInputStream.read(buffer)) > 0) {
        output.write(buffer, 0, length);
      }
      fileOutputStream.write(output.toByteArray());
      dataInputStream.close();
      fileOutputStream.close();
    } catch (MalformedURLException e) {
      e.printStackTrace();
    } catch (IOException e) {
      e.printStackTrace();
    }
  }

  /**
   * 向websocket中发送消息
   *
   * @param alarmsId
   */
  private void sendMessage(String alarmsId, String stationId, String eventType,String lineId) {
    AlarmsInfo ai = alarmsInfoService.queryById(alarmsId, stationId);
    Map<String, Object> map = new HashMap<>(16);
    map.put("id", ai.getId());
    map.put("stationId", stationId);
    map.put("lineId", lineId);
    map.put("eventName", ai.getEventName());
    map.put("eventTypeName", ai.getEventTypeName());
    map.put("eventLevel", ai.getEventLevel());
    map.put("occurrenceSite", ai.getOccurrenceSite());
    map.put("occurrenceTime", DateUtil.getPlusTime(ai.getOccurrenceTime()));
    map.put("resourceName", ai.getResourceName());
    map.put("resourceCode", ai.getResourceCode());
    map.put("status", ai.getStatus());
    // 黑名单报警
    if (Constants.STRING_2.equals(eventType)) {
      // 黑名单附件
      List<Map<String, Object>> list = alarmsService.getList(alarmsId, ai.getStationId());
      if (!list.isEmpty()) {
        map.put("path", list.get(0).get("path").toString());
      } else {
        map.put("path", null);
      }
    } else {
      if (ai.getFj() != null) {
        map.put("path", ai.getFj().getPath());
      } else {
        map.put("path", null);
      }
    }

    adminService.sendAlramsInfo(map);
  }

  /**
   * 执行动作
   *
   * @param resourceId
   * @param type
   */
  private Map<String, Object> executeAction(
      String actionId,
      String subCode,
      String brand,
      String stationId,
      String resourceId,
      String type,
      String action,
      String paramsName1,
      String paramsValue1,
      String paramsName2,
      String paramsValue2,
      String addressCode,
      String port,
      String username,
      String password,
      String channel,
      Date time) {
    Map<String, Object> map = new HashMap<>(10);
	// 枪机/球机
    if (Constants.ID_QIANG_JI.equals(type) || Constants.ID_QIU_JI.equals(type)) {
      CameraPojo pojo = new CameraPojo();
      pojo.setIp(addressCode);
      pojo.setPort(port);
      pojo.setUsername(username);
      pojo.setPassword(password);
      pojo.setChannel(channel);
      pojo.setStream("main");
      pojo.setTime(time);
      pojo.setParamsValue1(paramsValue1);
      pojo.setParamsValue2(paramsValue2);
      pojo.setStationId(stationId);
      pojo.setResourceId(resourceId);
      pojo.setUserId("0");
      pojo.setLevelType(1);
      pojo.setControlType(1);

      if (action.contains(Constants.PRESET)) {
        // 参数为预置位名称
        SysPreset sp = sysPresetService.getById(paramsValue1);
        pojo.setDwPtzCommand(39);
        pojo.setPreset(sp.getOrderNum());
        map = this.presetControl(pojo);
      } else if (Constants.CAPTURE.equals(action)) {
        map = this.captureJpegPictureCamera(pojo);
      } else if (Constants.VIDEO_DOWNLOAD.equals(action)) {
        map = this.videoDowload(pojo);
      }
    } else if (Constants.ID_QIU_JI.equals(type)) {

    } else if (Constants.ID_ZHAO_MING_DENG.equals(type)
        || Constants.ID_SHENG_GUANG_BAO_JING_QI.equals(type)
        || Constants.ID_MEN_JIN.equals(type)) {
      // 照明灯/声光报警器/门禁
      map =
          this.lightingOnOff(
              actionId, subCode, brand, resourceId, type, action, stationId, "0", "1", "1");
    }
    return map;
  }

  private void insertIntrude(String sysSign,String ruleActionId,String alarmsId,String resourceId,String resourceName,String subCode,String stationId,String typeName,String lineStationName,String actionInfo,int result) throws Exception {
    // 生成指令id
    String random = Math.random() + "";
    String rr = DateUtil.getNowPlusTimeMill() + random.substring(2, 6);
    // 写入指令
    switch (subCode) {
      case "01":
        // 视频监控
        OrVideoMonitor orVideoMonitor = new OrVideoMonitor(null,resourceId,resourceName,rr,actionInfo,result,"0","系统", new Date(),typeName,lineStationName,stationId,2,null,alarmsId,ruleActionId);
        orVideoMonitor.setSysSign(sysSign);
        orVideoMonitorService.save(orVideoMonitor);
        break;
      case "02":
        // 出入口控制
        OrGate orGate = new OrGate(null,resourceId,stationId,resourceName,rr,actionInfo,result,"0","系统",new Date(),typeName,lineStationName,2,null,alarmsId,ruleActionId);
        orGate.setSysSign(sysSign);
        orGateService.save(orGate);
        break;
      case "03":
        // 入侵报警
        OrIntrude orIntrude = new OrIntrude(null,resourceId,stationId,resourceName,rr,actionInfo,result,"0","系统",new Date(),typeName,lineStationName,2,null,alarmsId,ruleActionId);
        orIntrude.setSysSign(sysSign);
        orIntrudeService.save(orIntrude);
        break;
      case "04":
        // 安全检查
        OrSafetyCheck orSafetyCheck = new OrSafetyCheck(null,resourceId,stationId,resourceName,rr,actionInfo,result,"0","系统",new Date(),typeName,lineStationName,2,null,alarmsId,ruleActionId);
        orSafetyCheck.setSysSign(sysSign);
        orSafetyCheckService.save(orSafetyCheck);
        break;
      case "05":
        // 电子巡更
        break;
      default:
        break;
    }
  }

  private void saveLinkLogsAction(
      String id,
      String actionId,
      String actionDescribe,
      int result,
      HashMap<String, Object> link,
      HashMap<String, Object> action,
      Map<String, Object> map,
      String sysSign,String stationId) {
    // 写入联动日志
    LinkLogsAction linkLogsAction = new LinkLogsAction();
    linkLogsAction.setLogsId(id);
    linkLogsAction.setActionId(actionId);
    linkLogsAction.setCreateTime(new Date());
    linkLogsAction.setActionDescribe(actionDescribe);
    linkLogsAction.setResults(result);
    linkLogsAction.setSysSign(sysSign);
    linkLogsAction.setStationId(stationId);
    linkLogsActionService.save(linkLogsAction);
    // 存附件
    if (result == 1) {
      saveAttachment(link, action, linkLogsAction, map, sysSign,stationId);
    }
  }

  private void saveAttachment(
      HashMap<String, Object> link,
      HashMap<String, Object> action,
      LinkLogsAction linkLogsAction,
      Map<String, Object> map,
      String sysSign,String stationId) {
    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
    if (Constants.CAPTURE.toString().equals(action.get(Constants.ACTION_INFO))) {
      // 抓图张数
      ArrayList<LinkAttachment> list = new ArrayList<>();
      Integer paramsValue1 = Integer.parseInt((String) action.get("paramsValue1"));
      ArrayList<String> attachments =
          JSONObject.parseObject(JSONObject.toJSONString(map.get("attachment")), ArrayList.class);
      for (Integer i = 1; i <= paramsValue1; i++) {
        // 存储附件
        LinkAttachment linkAttachment = new LinkAttachment();
        linkAttachment.setLinkLogsActionId(linkLogsAction.getId());
        linkAttachment.setFileType("jpg");
        linkAttachment.setCreateTime(new Date());
        linkAttachment.setCreateUserId("0");
        if (attachments != null && attachments.get(i - 1) != null) {
          linkAttachment.setPath(attachments.get(i - 1));
        }
        linkAttachment.setSysSign(sysSign);
        linkAttachment.setStationId(stationId);
        linkAttachment.setName(link.get("resourceName") + sdf.format(new Date()) + i);
        list.add(linkAttachment);
      }
      linkAttachmentService.saveBatch(list);
    } else if (Constants.VIDEO_DOWNLOAD.equals(action.get(Constants.ACTION_INFO).toString())) {
      // action.equals("录像下载")
      LinkAttachment linkAttachment = new LinkAttachment();
      linkAttachment.setLinkLogsActionId(linkLogsAction.getId());
      linkAttachment.setFileType("mp4");
      linkAttachment.setCreateTime(new Date());
      linkAttachment.setCreateUserId("0");
      linkAttachment.setPath((String) map.get("attachment"));
      linkAttachment.setName(link.get("resourceName") + sdf.format(new Date()) + 1);
      linkAttachment.setSysSign(sysSign);
      linkAttachment.setStationId(stationId);
      linkAttachmentService.save(linkAttachment);
    }
  }

  @Override
  public Map<String, Object> getActionByType(
      String subCode, String resourceType, String brand, String stationId) {
    return baseMapper.getActionByType(subCode, resourceType, brand, stationId);
  }

  @Override
  public Boolean isResMsg(String stationId) {
    Integer level = baseMapper.queryLevel(stationId);
    SysSystem sysSystem =
        sysSystemService.getOne(
            new LambdaQueryWrapper<SysSystem>()
                .select(SysSystem::getType)
                .eq(SysSystem::getDeleted, 0));
    // 如果优先级为默认的转发服务器层级是当前系统层级，则接收消息
    if (level != null && level.intValue() == Integer.valueOf(sysSystem.getType()).intValue()) {
      return true;
    }
    return false;
  }

  @Override
  public Map<String, Object> getOneArUpConfig(String stationId) {
    return baseMapper.getOneArUpConfig(stationId);
  }

  @Override
  public void initMq(String stationId) {
    RabbitMqProvider rabbitMqProvider = new RabbitMqProvider();
    rabbitMqProvider.resMsg(host,username,password,port,virtualHost,stationId);
  }
}
