package com.devplatform.equipment.modules.invadedefence.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.devplatform.common.base.annotation.SysLog;
import com.devplatform.common.base.validator.ValidatorUtils;
import com.devplatform.common.util.R;
import com.devplatform.common.util.StringUtil;
import com.devplatform.equipment.common.annotation.SysLogMethod;
import com.devplatform.equipment.common.utils.AbstractController;
import com.devplatform.equipment.modules.invadedefence.bean.InvadeDefence;
import com.devplatform.equipment.modules.invadedefence.model.InvadeDefenceModel;
import com.devplatform.equipment.modules.invadedefence.service.InvadeDefenceService;
import com.devplatform.equipment.modules.invadedefenceresource.bean.InvadeDefenceResource;
import com.devplatform.equipment.modules.invadedefenceresource.service.InvadeDefenceResourceService;
import com.devplatform.equipment.modules.liresource.bean.LiResource;
import com.devplatform.equipment.modules.liresource.service.LiResourceService;
import com.devplatform.equipment.modules.listationmap.model.LiStationMapModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Administrator
 */
@Api(tags = {"入侵报警布防区域管理表接口"})
@RestController
@RequestMapping("/invadeDefence")
public class InvadeDefenceController extends AbstractController {

  @Autowired private InvadeDefenceService invadeDefenceService;

  @Autowired private InvadeDefenceResourceService invadeDefenceResourceService;

  @Autowired private LiResourceService liResourceService;

  /**
   * 根据站点id和查询站点入侵报警地图(如有资源点名则模糊查询)
   *
   * @param model 承接对象 stationId 当前站点id resourceName 资源点名
   * @return
   */
  @ApiOperation(value = "根据站点id查询站点入侵报警地图", notes = "根据站点id查询站点入侵报警地图")
  @ApiImplicitParam(name = "model", value = "参数", required = true, dataType = "LiStationMapModel")
  @PostMapping("/getStationMapCodeTreeList")
  public R getStationMapCodeTreeList(@RequestBody LiStationMapModel model) {
    List<Map<String, Object>> nodes = new ArrayList<>();
    model.setCreateUserId(getUserId());
    nodes = invadeDefenceService.queryByTreeList(model);
    return R.ok().put("nodes", nodes);
  }

  /**
   * 修改
   *
   * @param bean 入侵报警布防区域管理表对象 name 防区名 remark 防区简介
   * @return
   */
  @SysLog("修改入侵报警布防区域管理表")
  @SysLogMethod(operation = "修改", blockName = "入侵报警布防区域管理表", detail = "修改入侵报警布防区域管理表数据")
  @ApiOperation(value = "修改入侵报警布防区域管理表数据", notes = "修改入侵报警布防区域管理表数据")
  @PostMapping("/update")
  public R update(
      @RequestBody @ApiParam(value = "入侵报警布防区域管理表实体对象", required = true) InvadeDefence bean) {
    ValidatorUtils.validateEntity(bean);
    bean.setUpdateUserId(getUserId());
    bean.setUpdateTime(new Date());
    bean.setSysSign(getUser().getSysSystem().getCode());
    invadeDefenceService.updateById(bean);
    return R.ok();
  }

  /**
   * 根据ID修改入侵报警布防区域状态
   *
   * @param bean 承接对象 id 防区id status 状态(1=布防，0=撤防)
   * @return
   */
  @SysLog("修改入侵报警布防区域状态")
  @SysLogMethod(operation = "修改", blockName = "入侵报警布防区域状态", detail = "修改入侵报警布防区域状态")
  @ApiOperation(value = "根据ID修改入侵报警布防区域状态", notes = "根据ID修改入侵报警布防区域状态")
  @ApiImplicitParam(name = "bean", value = "布防区域对象", required = true, dataType = "InvadeDefence")
  @PostMapping("/updateStatus")
  public R updateStatus(@RequestBody InvadeDefence bean) {
    ValidatorUtils.validateEntity(bean);

      // 全部布防或撤防
    if (StringUtil.isNotEmpty(bean.getByx2())) {
      List<String> resourceIds = invadeDefenceResourceService.getAllResourceId(bean.getStationId());
      if (resourceIds != null && resourceIds.size() > 0) {
        for (int i = 0; i < resourceIds.size(); i++) {
          LiResource liResource = new LiResource();
          liResource.setId(resourceIds.get(i));
          liResource.setByx3(bean.getStatus());
          liResource.setSysSign(getUser().getSysSystem().getCode());
          liResourceService.update(liResource,new LambdaQueryWrapper<LiResource>().eq(LiResource::getId, resourceIds.get(i)).eq(StringUtil.checkNotNull(bean.getStationId()),LiResource::getStationId,bean.getStationId()));
        }
        return R.ok();
      } else {
        return R.error("所有防区下均无资源点，请添加资源点后重试");
      }
    } else {
      String id = bean.getId();
      if (id != null && !"".equals(id)) {
        InvadeDefence byId =invadeDefenceService.getOne(new LambdaQueryWrapper<InvadeDefence>().eq(InvadeDefence::getId, id).eq(StringUtil.checkNotNull(bean.getStationId()),InvadeDefence::getStationId,bean.getStationId()));
        if (byId != null) {
          // 防区状态修改,批量修改资源点布防状态
          List<InvadeDefenceResource> idfList =
              invadeDefenceResourceService.getByDefenceId(id, bean.getStationId());
          if (idfList != null && idfList.size() > 0) {
            for (int i = 0; i < idfList.size(); i++) {
              // 单个修改资源点布防状态
              LiResource bean2 = new LiResource();
              bean2.setId(idfList.get(i).getResourceId());
              bean2.setByx3(bean.getStatus());
              liResourceService.update(bean2,new LambdaQueryWrapper<LiResource>().eq(LiResource::getId, idfList.get(i).getResourceId()).eq(StringUtil.checkNotNull(idfList.get(i).getStationId()),LiResource::getStationId,idfList.get(i).getStationId()));
            }
            return R.ok();
          } else {
            return R.error("该防区下没有资源点，请添加资源点后重试");
          }
        } else {
          // 单个修改资源点布防状态
          LiResource bean2 = new LiResource();
          bean2.setId(id);
          bean2.setByx3(bean.getStatus());
          bean2.setSysSign(getUser().getSysSystem().getCode());
          boolean b = liResourceService.update(bean2,new LambdaQueryWrapper<LiResource>().eq(LiResource::getId, id).eq(StringUtil.checkNotNull(bean.getStationId()),LiResource::getStationId,bean.getStationId()));
          if (b) {
            return R.ok();
          } else {
            return R.error("请求错误，请刷新页面后重试");
          }
        }
      } else {
        return R.error("请求错误，请检查网络是否正常");
      }
    }
  }

  /**
   * 根据ID命令操作设备
   *
   * @param model 承接对象 id 防区id code 命令
   * @return
   */
  @ApiOperation(value = "根据ID命令操作设备", notes = "根据ID命令操作设备")
  @ApiImplicitParam(
      name = "bean",
      value = "根据ID命令操作设备",
      required = true,
      dataType = "InvadeDefence")
  @PostMapping("/commandControl")
  public R commandControl(@RequestBody InvadeDefenceModel model) {
    return invadeDefenceService.commandControl(model);
  }
}
