package com.devplatform.equipment.modules.invadedefence.dao;

import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.invadedefence.bean.InvadeDefence;
import com.devplatform.equipment.modules.invadedefence.model.InvadeDefenceModel;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

/**
 * InvadeDefence Mapper 用于入侵报警布防区域管理表的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface InvadeDefenceDao extends MyBaseMapper<InvadeDefence> {

  /**
   * 根据id删除防区
   * @param id
   * @param stationId
   */
  void delete(String id, String stationId);

  /**
   * 查询站点的防区
   * @param stationId
   * @return
   */
  List<InvadeDefence> getByStationId(String stationId);

  /**
   * 查询图层的防区
   * @param tierId
   * @param stationId
   * @return
   */
  List<InvadeDefence> getByTierId(String tierId, String stationId);

  /**
   * 查询站点所有防区
   * @param stationId
   * @return
   */
  List<InvadeDefence> queryByAllList(@Param("stationId") String stationId);

  /**
   * 查询已收藏防区
   * @param model
   * @return
   */
  List<InvadeDefence> queryByEnshrine(InvadeDefenceModel model);
}
