package com.devplatform.equipment.modules.invadedefence.service;

import com.devplatform.common.service.MyBaseService;
import com.devplatform.common.util.R;
import com.devplatform.equipment.modules.invadedefence.bean.InvadeDefence;
import com.devplatform.equipment.modules.invadedefence.model.InvadeDefenceModel;
import com.devplatform.equipment.modules.listationmap.model.LiStationMapModel;
import java.util.List;
import java.util.Map;

/**
 * 入侵报警布防区域管理表的service接口 <br>
 * <b>功能：</b>InvadeDefenceService<br>
 *
 * @author 代码生成器产生
 */
public interface InvadeDefenceService extends MyBaseService<InvadeDefence> {

  /**
   * 删除防区
   * @param id
   * @param stationId
   */
  void deleteById(String id, String stationId);

  /**
   * 级联修改
   * @param model
   */
  void updateCascade(InvadeDefenceModel model);

  /**
   * 根据站点id获取
   *
   * @param stationId
   * @return
   */
  List<InvadeDefence> getByStationId(String stationId);

  /**
   * 根据站层id获取
   * @param tierId
   * @param stationId
   * @return
   */
  List<InvadeDefence> getByTierId(String tierId, String stationId);

  /**
   * 查询防区
   * @param model
   * @return
   */
  List<Map<String, Object>> queryByTreeList(LiStationMapModel model);

  /**
   * 查询所有防区
   * @param stationId
   * @return
   */
  List<InvadeDefence> queryByAllList(String stationId);

  /**
   * 查询所有收藏的防区
   * @param model
   * @return
   */
  List<InvadeDefence> queryByEnshrine(InvadeDefenceModel model);

  /**
   * 控制命令
   * @param model
   * @return
   */
  R commandControl(InvadeDefenceModel model);
}
