package com.devplatform.equipment.modules.invadedefence.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.devplatform.common.service.impl.MyBaseServiceImpl;
import com.devplatform.common.util.R;
import com.devplatform.equipment.common.utils.Constants;
import com.devplatform.equipment.modules.invadedefence.bean.InvadeDefence;
import com.devplatform.equipment.modules.invadedefence.dao.InvadeDefenceDao;
import com.devplatform.equipment.modules.invadedefence.model.InvadeDefenceModel;
import com.devplatform.equipment.modules.invadedefence.service.InvadeDefenceService;
import com.devplatform.equipment.modules.invadedefenceresource.bean.InvadeDefenceResource;
import com.devplatform.equipment.modules.invadedefenceresource.service.InvadeDefenceResourceService;
import com.devplatform.equipment.modules.liresource.bean.LiResource;
import com.devplatform.equipment.modules.liresource.service.LiResourceService;
import com.devplatform.equipment.modules.listationmap.bean.LiStationMap;
import com.devplatform.equipment.modules.listationmap.model.LiStationMapModel;
import com.devplatform.equipment.modules.listationmap.service.LiStationMapService;
import com.devplatform.equipment.modules.sysdictionary.service.SysDictionaryService;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 入侵报警布防区域管理表的service接口实现类 <br>
 * <b>功能：</b>InvadeDefenceServiceImpl<br>
 *
 * @author 代码生成器产生
 */
@Service("invadeDefenceService")
public class InvadeDefenceServiceImpl extends MyBaseServiceImpl<InvadeDefenceDao, InvadeDefence>
    implements InvadeDefenceService {
  @Autowired private InvadeDefenceResourceService invadeDefenceResourceService;
  @Autowired private InvadeDefenceService invadeDefenceService;
  @Autowired private LiStationMapService liStationMapService;
  @Autowired private LiResourceService liResourceService;
  @Autowired private SysDictionaryService sysDictionaryService;

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void deleteById(String id, String stationId) {
    baseMapper.delete(id, stationId);
    // 删除该防区下的所有资源
    invadeDefenceResourceService.deleteByDefenceId(id, stationId);
  }

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void updateCascade(InvadeDefenceModel model) {
    InvadeDefence invadeDefence = new InvadeDefence();
    BeanUtils.copyProperties(model, invadeDefence);
    updateById(invadeDefence);
    // 删除原来的防区资源点对象
    invadeDefenceResourceService.deleteByDefenceId(model.getId(), model.getStationId());
    ArrayList<InvadeDefenceResource> list = new ArrayList<>();
    List<String> idList = model.getList();
    for (String id : idList) {
      InvadeDefenceResource invadeDefenceResource = new InvadeDefenceResource();
      invadeDefenceResource.setDefenceId(model.getId());
      invadeDefenceResource.setResourceId(id);
      invadeDefenceResource.setStationId(model.getStationId());
      list.add(invadeDefenceResource);
    }
    invadeDefenceResourceService.saveBatch(list);
  }

  @Override
  public List<InvadeDefence> getByStationId(String stationId) {
    return baseMapper.getByStationId(stationId);
  }

  @Override
  public List<InvadeDefence> getByTierId(String tierId, String stationId) {
    return baseMapper.getByTierId(tierId, stationId);
  }

  @Override
  public List<Map<String, Object>> queryByTreeList(LiStationMapModel model) {
	// 查询收藏夹会用到的参数
    String createUserId = model.getCreateUserId();
    List<Map<String, Object>> nodes = new ArrayList<>();
	// 初始化创建人
    model.setCreateUserId(null);
    // 查询当前站点相应所有层级
    List<LiStationMap> list = liStationMapService.getTreeList(model);
    if (list != null && list.size() > 0) {
      // 查询当前所有防区
      List<InvadeDefence> invadeDefenceList2 = new ArrayList<InvadeDefence>();
	// 标记，为1时查询收藏夹，其他则是查询所有
      if (model.getTag() == 1) {
        InvadeDefenceModel idfm = new InvadeDefenceModel();
	// 模糊查询的资源点名字
        idfm.setName(model.getResourceName());
	// 创建人
        idfm.setCreateUserId(createUserId);
        idfm.setStationId(model.getStationId());
        invadeDefenceList2 = invadeDefenceService.queryByEnshrine(idfm);
      } else {
        invadeDefenceList2 = invadeDefenceService.queryByAllList(model.getStationId());
      }

      for (int i = 0; i < list.size(); i++) {
        int num = 0;
        Map<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("id", list.get(i).getId());
	// 站层名称
        map.put("name", list.get(i).getName());
        map.put("readPath", list.get(i).getReadPath());
	// 站层等级
        map.put("level", 4);

        // 循环判断，当前层级是否存在防区
        List<InvadeDefence> invadeDefenceList = new ArrayList<InvadeDefence>();
        if (invadeDefenceList2 != null && invadeDefenceList2.size() > 0) {
          String id = list.get(i).getId();
          for (int ik = 0; ik < invadeDefenceList2.size(); ik++) {
            String tierId = invadeDefenceList2.get(ik).getTierId();
            if (id == tierId || id.equals(tierId)) {
              invadeDefenceList.add(invadeDefenceList2.get(ik));
            }
          }
        }

        if (invadeDefenceList != null && invadeDefenceList.size() > 0) {
          List<Map<String, Object>> childrenDic = new ArrayList<>();
          for (int j = 0; j < invadeDefenceList.size(); j++) {
            InvadeDefence invadeDefence = invadeDefenceList.get(j);
            Map<String, Object> mapChildren = JSONObject.parseObject(JSONObject.toJSONString(invadeDefence), Map.class);
	// 是否防区标识
            mapChildren.put("isDefence", true);
	// 等级
            mapChildren.put("level", 5);
            mapChildren.put("pid", list.get(i).getId());
            mapChildren.put("readPath", list.get(i).getReadPath());
            List<LiResource> resourceList = liResourceService.queryByDefenceId(invadeDefenceList.get(j).getId());
            if (resourceList != null && resourceList.size() > 0) {
              List<Map<String, Object>> childrenDic2 = new ArrayList<>();
              for (int k = 0; k < resourceList.size(); k++) {
                Map<String, Object> mapChildren2 = JSONObject.parseObject(JSONObject.toJSONString(resourceList.get(k)), Map.class);
                if (mapChildren2 != null) {
                  childrenDic2.add(calcMap(mapChildren2,resourceList.get(k).getName(),resourceList.get(k).getByx2(),list.get(i).getReadPath(),list.get(i).getId(),invadeDefence));
                }
              }
              num += childrenDic2.size();
	// 把当前防区下所有的资源，绑定到防区
              mapChildren.put("children", childrenDic2);
            }
            childrenDic.add(mapChildren);
          }
	// 把当前站层下所有的防区，绑定到站层上
          map.put("children", childrenDic);
        }
	// 收藏夹
        if (model.getTag() == 1) {
	// 该层级下有资源点，收藏夹才会显示
          if (num > 0) {
	// 把当前站层所有数据，让如树中
            nodes.add(map);
          }
        } else {
	// 把当前站层所有数据，让如树中
          nodes.add(map);
        }
      }
    }
    return nodes;
  }

  private Map<String, Object> calcMap(Map<String, Object> mapChildren2,String name,String byx2,String readPath,String mapId,InvadeDefence invadeDefence){
    // 设置在线和离线状态标记---资源点名称+状态
    // 证明有在线状态更新
    if (byx2 != null && !"".equals(byx2)) {
      if (Constants.STRING_1.equals(byx2)) {
        name = name + "[在线]";
      } else {
        name = name + "[离线]";
      }
      // 资源点名称
      mapChildren2.put("name", name);
    }
    // 资源点名称
    mapChildren2.put("name", name);
    // 等级
    mapChildren2.put("level", 6);
    mapChildren2.put("pid", invadeDefence.getId());
    mapChildren2.put("p_width", invadeDefence.getWidth());
    mapChildren2.put("p_height", invadeDefence.getHeight());
    mapChildren2.put("p_xpoint", invadeDefence.getXpoint());
    mapChildren2.put("p_ypoint", invadeDefence.getYpoint());
    mapChildren2.put("p_xlongit", invadeDefence.getXlongit());
    mapChildren2.put("p_ylat", invadeDefence.getYlat());
    mapChildren2.put("readPath", readPath);
    mapChildren2.put("mapId", mapId);
    return mapChildren2;
  }

  @Override
  public List<InvadeDefence> queryByAllList(String stationId) {
    return baseMapper.queryByAllList(stationId);
  }

  @Override
  public List<InvadeDefence> queryByEnshrine(InvadeDefenceModel model) {
    return baseMapper.queryByEnshrine(model);
  }

  @Override
  public R commandControl(InvadeDefenceModel model) {
    //        stationId	站点id	int
    //        list	资源点id集合	List<String>
    //        orderNum	命令参数，1=撤防，2=布防，3=照明开，4=照明关，5=消除报警	[object]

    return R.ok();
  }
}
