package com.devplatform.equipment.modules.invadedefenceresource.dao;

import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.invadedefenceresource.bean.InvadeDefenceResource;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

/**
 * InvadeDefenceResource Mapper 用于入侵报警布防区域资源点管理的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface InvadeDefenceResourceDao extends MyBaseMapper<InvadeDefenceResource> {

  /**
   * 删除防区资源点
   * @param id
   * @param stationId
   */
  void deleteByDefenceId(String id, String stationId);

  /**
   * 查询防区资源点
   * @param defenceId
   * @param stationId
   * @return
   */
  List<InvadeDefenceResource> getByDefenceId(String defenceId, String stationId);

  /**
   * 查询防区资源点id
   * @param stationId
   * @return
   */
  List<String> getAllResourceId(@Param("stationId") String stationId);
}
