package com.devplatform.equipment.modules.lienshrine.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.devplatform.common.base.annotation.SysLog;
import com.devplatform.common.base.validator.ValidatorUtils;
import com.devplatform.common.util.R;
import com.devplatform.equipment.common.annotation.SysLogMethod;
import com.devplatform.equipment.common.utils.AbstractController;
import com.devplatform.equipment.common.utils.Constants;
import com.devplatform.equipment.modules.invadedefence.bean.InvadeDefence;
import com.devplatform.equipment.modules.invadedefence.model.InvadeDefenceModel;
import com.devplatform.equipment.modules.invadedefence.service.InvadeDefenceService;
import com.devplatform.equipment.modules.lienshrine.bean.LiEnshrine;
import com.devplatform.equipment.modules.lienshrine.service.LiEnshrineService;
import com.devplatform.equipment.modules.liresource.bean.LiResource;
import com.devplatform.equipment.modules.liresource.model.LiResourceModel;
import com.devplatform.equipment.modules.liresource.service.LiResourceService;
import com.devplatform.equipment.modules.listation.bean.LiStation;
import com.devplatform.equipment.modules.listation.service.LiStationService;
import com.devplatform.equipment.modules.listationmap.bean.LiStationMap;
import com.devplatform.equipment.modules.listationmap.model.LiStationMapModel;
import com.devplatform.equipment.modules.listationmap.service.LiStationMapService;
import com.devplatform.equipment.modules.sysdictionary.bean.SysDictionary;
import com.devplatform.equipment.modules.sysdictionary.service.SysDictionaryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Administrator
 */
@Api(tags = {"收藏夹表接口"})
@RestController
@RequestMapping("/liEnshrine")
public class LiEnshrineController extends AbstractController {
  @Autowired private LiEnshrineService liEnshrineService;
  @Autowired private LiResourceService liResourceService;
  @Autowired private LiStationMapService liStationMapService;
  @Autowired private InvadeDefenceService invadeDefenceService;

  /**
   * 根据站点id查询站点收藏夹地图
   *
   * @param model 承接对象 stationId 当前站点id subCode 子系统编码 resourceName 资源点名字（用来作收藏夹搜索）
   * @return
   */
  @ApiOperation(value = "根据站点id查询站点收藏夹地图", notes = "根据站点id查询站点收藏夹地图")
  @ApiImplicitParam(name = "model", value = "参数", required = true, dataType = "LiStationMapModel")
  @PostMapping("/getEnshrineStationMapTreeList")
  public R getEnshrineStationMapTreeList(@RequestBody LiStationMapModel model) {
    List<Map<String, Object>> nodes = new ArrayList<>();
	// 如果是视频监控-实时监控，一级不让勾选
    int pd = 0;
    if (model.getByx1() != null && !"".equals(model.getByx1()) && Constants.SP.equals(model.getByx1())) {
      pd = 1;
      model.setByx1(null);
    }
	// 如果是入侵报警子系统进入，数据模块不同，改变查询方式
    if (model.getSubCode() != null && Constants.STRING_03.equals(model.getSubCode())) {
	// 标记为入侵报警收藏夹查询，没有1则是所有查询
      model.setTag(1);
      nodes = invadeDefenceService.queryByTreeList(model);
      return R.ok().put("nodes", nodes);
    } else if (model.getSubCode() != null) {
      nodes = liEnshrineService.queryByTreeList(model,getUserId(),pd);
      return R.ok().put("nodes", nodes);
    } else {
      nodes = liEnshrineService.queryDzdtByTreeList(model,getUserId());
      return R.ok().put("nodes", nodes);
    }
  }

  /**
   * 根据站点id查询站点收藏夹地图
   *
   * @param model 承接对象 stationId 当前站点id subCode 子系统编码 resourceName 资源点名字（用来作收藏夹搜索）
   * @return
   */
  @ApiOperation(value = "根据站点id查询站点收藏夹地图", notes = "根据站点id查询站点收藏夹地图")
  @ApiImplicitParam(name = "model", value = "参数", required = true, dataType = "LiStationMapModel")
  @PostMapping("/getAjEnshrineStationMapTreeList")
  public R getAjEnshrineStationMapTreeList(@RequestBody LiStationMapModel model) {
    List<Map<String, Object>> nodes = new ArrayList<>();
    LiResourceModel lrm = new LiResourceModel();
	// 查出当前用户收藏的所有资源点
    lrm.setCreateUserId(getUserId());
	// 当前站点的
    lrm.setStationId(model.getStationId());
	// 过滤出子系统编码相同的
    lrm.setSubCode(model.getSubCode());
    lrm.setType(model.getResourceType());
    // 查出收藏的所有资源点
    List<LiResource> resourceList = liResourceService.queryByEnshrine(lrm);
    // 查询当前站点相应所有层级
    List<LiStationMap> list = liStationMapService.getTreeList(model);
    if (list != null && list.size() > 0) {
      for (int i = 0; i < list.size(); i++) {
        Map<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("id", list.get(i).getId());
	// 站层名称
        map.put("name", list.get(i).getName());
	// 站层等级
        map.put("level", 4);

        List<Map<String, Object>> childrenDic = new ArrayList<>();
        if (resourceList != null && resourceList.size() > 0) {
          for (int j = 0; j < resourceList.size(); j++) {
            // 判断是否是当前站层的资源点
            if (resourceList.get(j).getTierId().equals(list.get(i).getId())) {
              Map<String, Object> mapChildren =
                  JSONObject.parseObject(JSONObject.toJSONString(resourceList.get(j)), Map.class);
              // 设置在线和离线状态标记---资源点名称+状态
              String name = resourceList.get(j).getName();
              String byx2 = resourceList.get(j).getByx2();
	// 证明有在线状态更新
              if (byx2 != null && !"".equals(byx2)) {
                if ("1".equals(byx2)) {
                  name = name + "[在线]";
                } else {
                  name = name + "[离线]";
                }
	// 资源点名称
                mapChildren.put("name", name);
              }
	// 等级
              mapChildren.put("level", 6);
              mapChildren.put("pid", list.get(i).getId());
              childrenDic.add(mapChildren);
            }
          }
	// 把当前站层下所有的资源点，绑定到站层上
          map.put("children", childrenDic);
        }
	// 如果该站层下有收藏的资源点则添加站层
        if (childrenDic != null && childrenDic.size() > 0) {
	// 站层加入树中
          nodes.add(map);
        }
      }
    }
    return R.ok().put("nodes", nodes);
  }

  /**
   * 添加
   *
   * @param bean 收藏夹表对象1
   * @return
   */
  @SysLog("添加收藏夹表")
  @SysLogMethod(operation = "新增", blockName = "收藏夹表", detail = "新增收藏夹表数据")
  @ApiOperation(value = "新增收藏夹表数据", notes = "新增收藏夹表数据")
  @PostMapping("/save")
  public R save(@RequestBody @ApiParam(value = "收藏夹表实体对象", required = true) LiEnshrine bean) {
    ValidatorUtils.validateEntity(bean);
    bean.setCreateUserId(getUserId());
    // 判断是否已收藏
    LiEnshrine byResourceId = liEnshrineService.getByResourceId(bean);
	// 判断是否被逻辑删除
    if (byResourceId != null) {
	// 已经存在，收藏过了
      return R.error(-1, "已经收藏过了！");
    } else {
      bean.setCreateTime(new Date());
      bean.setSysSign(getUser().getSysSystem().getCode());
      liEnshrineService.save(bean);
      return R.ok("收藏成功");
    }
  }

  /**
   * 删除收藏夹表对象
   *
   * @param bean 收藏夹表对象
   * @return
   */
  @SysLog("删除收藏夹表")
  @SysLogMethod(operation = "删除", blockName = "收藏夹表", detail = "删除收藏夹表数据")
  @ApiOperation(value = "删除收藏夹表数据", notes = "删除收藏夹表数据")
  @PostMapping("/delete")
  public R delete(@RequestBody @ApiParam(value = "收藏夹表实体对象", required = true) LiEnshrine bean) {
    liEnshrineService.remove(
        new QueryWrapper<LiEnshrine>().eq("resource_id", bean.getResourceId()));
    return R.ok();
  }
}
