package com.devplatform.equipment.modules.lienshrine.dao;

import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.lienshrine.bean.LiEnshrine;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

/**
 * LiEnshrine Mapper 用于收藏夹表的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface LiEnshrineDao extends MyBaseMapper<LiEnshrine> {

  /**
   * 查询收藏夹数据
   * @param userId
   * @param stationId
   * @return
   */
  List<LiEnshrine> getByCreateUserId(String userId, String stationId);

  /**
   * 删除收藏夹内容
   * @param liEnshrine
   */
  void deleteByResourceId(LiEnshrine liEnshrine);

  /**
   * 查询收藏夹数据
   * @param liEnshrine
   * @return
   */
  LiEnshrine getByResourceId(LiEnshrine liEnshrine);
}
