package com.devplatform.equipment.modules.lienshrine.service;

import com.devplatform.common.service.MyBaseService;
import com.devplatform.equipment.modules.lienshrine.bean.LiEnshrine;
import com.devplatform.equipment.modules.listationmap.model.LiStationMapModel;

import java.util.List;
import java.util.Map;

/**
 * 收藏夹表的service接口 <br>
 * <b>功能：</b>LiEnshrineService<br>
 *
 * @author 代码生成器产生
 */
public interface LiEnshrineService extends MyBaseService<LiEnshrine> {

    /**
     * 逻辑删除
     *
     * @param liEnshrine
     */
    void deleteByResourceId(LiEnshrine liEnshrine);

    /**
     * 根据资源id获取收藏夹
     *
     * @param liEnshrine
     * @return
     */
    LiEnshrine getByResourceId(LiEnshrine liEnshrine);

    /**
     * 根据用户id获取收藏夹
     *
     * @param userId
     * @param stationId
     * @return
     */
    List<LiEnshrine> getByCreateUserId(String userId, String stationId);

    /**
     * 除电子地图外的收藏夹树
     * @param model
     * @param userId
     * @param pd
     * @return
     */
    List<Map<String, Object>> queryByTreeList(LiStationMapModel model, String userId, int pd);

    /**
     * 电子地图收藏夹树
     * @param model
     * @param userId
     * @return
     */
    List<Map<String, Object>> queryDzdtByTreeList(LiStationMapModel model, String userId);
}
