package com.devplatform.equipment.modules.lienshrine.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.devplatform.common.service.impl.MyBaseServiceImpl;
import com.devplatform.equipment.common.utils.Constants;
import com.devplatform.equipment.modules.invadedefence.bean.InvadeDefence;
import com.devplatform.equipment.modules.invadedefence.model.InvadeDefenceModel;
import com.devplatform.equipment.modules.invadedefence.service.InvadeDefenceService;
import com.devplatform.equipment.modules.lienshrine.bean.LiEnshrine;
import com.devplatform.equipment.modules.lienshrine.dao.LiEnshrineDao;
import com.devplatform.equipment.modules.lienshrine.service.LiEnshrineService;
import com.devplatform.equipment.modules.liresource.bean.LiResource;
import com.devplatform.equipment.modules.liresource.model.LiResourceModel;
import com.devplatform.equipment.modules.liresource.service.LiResourceService;
import com.devplatform.equipment.modules.listation.bean.LiStation;
import com.devplatform.equipment.modules.listation.service.LiStationService;
import com.devplatform.equipment.modules.listationmap.bean.LiStationMap;
import com.devplatform.equipment.modules.listationmap.model.LiStationMapModel;
import com.devplatform.equipment.modules.listationmap.service.LiStationMapService;
import com.devplatform.equipment.modules.sysdictionary.bean.SysDictionary;
import com.devplatform.equipment.modules.sysdictionary.service.SysDictionaryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * 收藏夹表的service接口实现类 <br>
 * <b>功能：</b>LiEnshrineServiceImpl<br>
 *
 * @author 代码生成器产生
 */
@Service("liEnshrineService")
public class LiEnshrineServiceImpl extends MyBaseServiceImpl<LiEnshrineDao, LiEnshrine> implements LiEnshrineService {
    @Autowired
    private LiResourceService liResourceService;
    @Autowired
    private LiStationMapService liStationMapService;
    @Autowired
    private InvadeDefenceService invadeDefenceService;
    @Autowired
    private LiStationService liStationService;
    @Autowired
    private SysDictionaryService sysDictionaryService;

    @Override
    public void deleteByResourceId(LiEnshrine liEnshrine) {
        baseMapper.deleteByResourceId(liEnshrine);
    }

    @Override
    public LiEnshrine getByResourceId(LiEnshrine liEnshrine) {
        return baseMapper.getByResourceId(liEnshrine);
    }

    @Override
    public List<LiEnshrine> getByCreateUserId(String userId, String stationId) {
        return baseMapper.getByCreateUserId(userId, stationId);
    }

    @Override
    public List<Map<String, Object>> queryByTreeList(LiStationMapModel model, String userId, int pd) {
        List<Map<String, Object>> nodes = new ArrayList<>();
        LiResourceModel lrm = new LiResourceModel();
        // 查出当前用户收藏的所有资源点
        lrm.setCreateUserId(userId);
        // 当前站点的
        lrm.setStationId(model.getStationId());
        // 过滤出子系统编码相同的
        lrm.setSubCode(model.getSubCode());
        // 模糊查询过滤资源点名字
        lrm.setName(model.getResourceName());
        // 查出收藏的所有资源点
        List<LiResource> resourceList = liResourceService.queryByEnshrine(lrm);
        // 查询当前站点相应所有层级
        List<LiStationMap> list = liStationMapService.getTreeList(model);
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                Map<String, Object> map = new LinkedHashMap<String, Object>();
                map.put("id", list.get(i).getId());
                // 站层名称
                map.put("name", list.get(i).getName());
                map.put("key", UUID.randomUUID());
                // 站层等级
                map.put("level", 4);
                if (pd == 1) {
                    // 如果是视频监控-实时监控，一级不让勾选
                    map.put("disabled", true);
                }
                List<Map<String, Object>> childrenDic = new ArrayList<>();
                if (resourceList != null && resourceList.size() > 0) {
                    for (int j = 0; j < resourceList.size(); j++) {
                        // 判断是否是当前站层的资源点
                        if (resourceList.get(j).getTierId().equals(list.get(i).getId())) {
                            Map<String, Object> mapChildren = JSONObject.parseObject(JSONObject.toJSONString(resourceList.get(j)), Map.class);
                            // 设置在线和离线状态标记---资源点名称+状态
                            String name = resourceList.get(j).getName();
                            String byx2 = resourceList.get(j).getByx2();
                            // 证明有在线状态更新
                            if (byx2 != null && !"".equals(byx2)) {
                                if ("1".equals(byx2)) {
                                    name = name + "[在线]";
                                } else {
                                    name = name + "[离线]";
                                }
                                // 资源点名称
                                mapChildren.put("name", name);
                            }
                            mapChildren.put("key", UUID.randomUUID());
                            // 等级
                            mapChildren.put("level", 6);
                            mapChildren.put("pid", list.get(i).getId());
                            childrenDic.add(mapChildren);
                        }
                    }
                    // 把当前站层下所有的资源点，绑定到站层上
                    map.put("children", childrenDic);
                }
                // 如果该站层下有收藏的资源点则添加站层
                if (childrenDic != null && childrenDic.size() > 0) {
                    // 站层加入树中
                    nodes.add(map);
                }
            }
        }
        return nodes;
    }

    @Override
    public List<Map<String, Object>> queryDzdtByTreeList(LiStationMapModel model, String userId) {
        // 电子地图首页，查询所有收藏夹----------
        List<Map<String, Object>> nodes = new ArrayList<>();
        LiStation station = liStationService.getById(model.getStationId());
        Map<String, Object> root = JSONObject.parseObject(JSONObject.toJSONString(station), Map.class);
        root.put("name", station.getStationName());
        root.put("key", UUID.randomUUID());
        root.put("level", 3);
        List<Map<String, Object>> rootChild = new ArrayList<>();
        // 查询该站点下站层地图
        LiStationMapModel mapModel = new LiStationMapModel();
        mapModel.setStationId(model.getStationId());
        List<LiStationMap> list = liStationMapService.getTreeList(mapModel);

        LiResourceModel lrm = new LiResourceModel();
        // 查出当前用户收藏的所有资源点
        lrm.setCreateUserId(userId);
        // 当前站点的
        lrm.setStationId(model.getStationId());
        // 模糊查询过滤资源点名字
        lrm.setName(model.getResourceName());
        // 查出收藏的所有资源点
        List<LiResource> resourceList = liResourceService.queryByEnshrine(lrm);

        // 查询子系统字典项
        List<SysDictionary> dicList = new ArrayList<>();
        dicList = sysDictionaryService.queryByPid(Constants.SUB_SYSTEM_ID, model.getStationId());

        // 查询当前所有防区
        List<InvadeDefence> invadeDefenceList2 = new ArrayList<InvadeDefence>();
        InvadeDefenceModel idfm = new InvadeDefenceModel();
        // 模糊查询的资源点名字
        idfm.setName(model.getResourceName());
        // 创建人
        idfm.setCreateUserId(userId);
        idfm.setStationId(model.getStationId());
        invadeDefenceList2 = invadeDefenceService.queryByEnshrine(idfm);

        for (LiStationMap liStationMap : list) {
            rootChild = setChildren(rootChild,invadeDefenceList2,liStationMap,dicList,resourceList);
        }
        root.put("children", rootChild);
        if (rootChild != null && rootChild.size() > 0) {
            nodes.add(root);
        }
        return nodes;
    }

    private List<Map<String, Object>> setChildren(List<Map<String, Object>> rootChild,List<InvadeDefence> invadeDefenceList2, LiStationMap liStationMap,List<SysDictionary> dicList,List<LiResource> resourceList) {
        int num = 0;
        Map<String, Object> mapStationMap = JSONObject.parseObject(JSONObject.toJSONString(liStationMap), Map.class);
        mapStationMap.put("key", UUID.randomUUID());
        mapStationMap.put("level", 4);
        List<Map<String, Object>> childrenStationMap = new ArrayList<>();
        // 入侵防区//循环判断，当前层级是否存在防区
        List<InvadeDefence> invadeDefenceList = new ArrayList<InvadeDefence>();
        if (invadeDefenceList2 != null && invadeDefenceList2.size() > 0) {
            String id = liStationMap.getId();
            for (int ik = 0; ik < invadeDefenceList2.size(); ik++) {
                String tierId = invadeDefenceList2.get(ik).getTierId();
                if (id == tierId || id.equals(tierId)) {
                    invadeDefenceList.add(invadeDefenceList2.get(ik));
                }
            }
        }
        for (SysDictionary dic : dicList) {
            int dcnum = 0;
            if ("05".equals(dic.getValue())) {
                break;
            }
            Map<String, Object> mapDic = JSONObject.parseObject(JSONObject.toJSONString(dic), Map.class);
            // 两个id拼接保证id的唯一性
            mapDic.put("id", liStationMap.getId() + dic.getId());
            mapDic.put("code", dic.getValue());
            mapDic.put("stationId", liStationMap.getStationId());
            mapDic.put("tierId", liStationMap.getId());
            mapDic.put("key", UUID.randomUUID());
            mapDic.put("level", 5);
            if ("03".equals(dic.getValue())) {
                List<Map<String, Object>> childrenDic12 = new ArrayList<>();
                // 循环防区
                for (InvadeDefence invadeDefence : invadeDefenceList) {
                    Map<String, Object> mapChildren = JSONObject.parseObject(JSONObject.toJSONString(invadeDefence), Map.class);
                    // 是否防区标识
                    mapChildren.put("isDefence", true);
                    mapChildren.put("level", 6);
                    mapChildren.put("key", UUID.randomUUID());
                    mapChildren.put("pid", liStationMap.getId() + dic.getId());
                    List<LiResource> resourceList2 = liResourceService.queryByDefenceId(invadeDefence.getId());
                    List<Map<String, Object>> childrenDic2 = new ArrayList<>();
                    if (resourceList2 != null && resourceList2.size() > 0) {
                        for (int k = 0; k < resourceList2.size(); k++) {
                            childrenDic2 = setDicChildren(childrenDic2,resourceList2.get(k),invadeDefence);
                        }
                        num += childrenDic2.size();
                        dcnum += childrenDic2.size();
                        // 把当前防区下所有的资源，绑定到防区
                        mapChildren.put("children", childrenDic2);
                    }
                    // 该防区下有收藏资源点才会显示
                    if (childrenDic2 != null && childrenDic2.size() > 0) {
                        childrenDic12.add(mapChildren);
                    }
                }
                // 该子系统下有收藏资源点才会显示
                if (dcnum > 0) {
                    mapDic.put("children", childrenDic12);
                }
            } else {
                List<Map<String, Object>> childrenDic = new ArrayList<>();
                for(LiResource liResource : resourceList){
                    if (dic.getValue().equals(liResource.getSubCode()) && liStationMap.getId().equals(liResource.getTierId())) {
                        childrenDic = setDicChildren2(childrenDic,liResource,(liStationMap.getId() + dic.getId()));
                    }
                }
                num += childrenDic.size();
                dcnum = childrenDic.size();
                mapDic.put("children", childrenDic);
            }
            // 该子系统下有收藏资源点才会显示
            if (dcnum > 0) {
                childrenStationMap.add(mapDic);
            }
        }
        mapStationMap.put("children", childrenStationMap);
        // 该站层下有收藏资源点才会显示
        if (num > 0) {
            rootChild.add(mapStationMap);
        }
        return rootChild;
    }

    private List<Map<String, Object>> setDicChildren(List<Map<String, Object>> childrenDic2,LiResource liResource,InvadeDefence invadeDefence){
        Map<String, Object> mapChildren2 = JSONObject.parseObject(JSONObject.toJSONString(liResource), Map.class);
        // 设置在线和离线状态标记---资源点名称+状态
        String name = liResource.getName();
        String byx2 = liResource.getByx2();
        // 证明有在线状态更新
        if (byx2 != null && !"".equals(byx2)) {
            if (Constants.STRING_1.equals(byx2)) {
                name = name + "[在线]";
            } else {
                name = name + "[离线]";
            }
            // 资源点名称
            mapChildren2.put("name", name);
        }
        // 等级
        mapChildren2.put("level", 7);
        mapChildren2.put("key", UUID.randomUUID());
        mapChildren2.put("pid", invadeDefence.getId());
        mapChildren2.put("p_width", invadeDefence.getWidth());
        mapChildren2.put("p_height", invadeDefence.getHeight());
        mapChildren2.put("p_xpoint", invadeDefence.getXpoint());
        mapChildren2.put("p_ypoint", invadeDefence.getYpoint());
        mapChildren2.put("p_xlongit", invadeDefence.getXlongit());
        mapChildren2.put("p_ylat", invadeDefence.getYlat());
        childrenDic2.add(mapChildren2);
        return childrenDic2;
    }

    private List<Map<String, Object>> setDicChildren2(List<Map<String, Object>> childrenDic,LiResource liResource,String pid){
        Map<String, Object> mapResource = JSONObject.parseObject(JSONObject.toJSONString(liResource), Map.class);
        // 设置在线和离线状态标记---资源点名称+状态
        String name = liResource.getName();
        String byx2 = liResource.getByx2();
        // 证明有在线状态更新
        if (byx2 != null && !"".equals(byx2)) {
            if (Constants.STRING_1.equals(byx2)) {
                name = name + "[在线]";
            } else {
                name = name + "[离线]";
            }
            // 资源点名称
            mapResource.put("name", name);
        }
        mapResource.put("level", 6);
        mapResource.put("active", false);
        // 拖拽的唯一标识
        mapResource.put("key", UUID.randomUUID());
        mapResource.put("pid", pid);
        childrenDic.add(mapResource);
        return childrenDic;
    }
}
