package com.devplatform.equipment.modules.liline.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.devplatform.common.base.annotation.SysLog;
import com.devplatform.common.base.validator.ValidatorUtils;
import com.devplatform.common.util.PageUtils;
import com.devplatform.common.util.R;
import com.devplatform.common.util.StringUtil;
import com.devplatform.equipment.common.annotation.SysLogMethod;
import com.devplatform.equipment.common.utils.AbstractController;
import com.devplatform.equipment.modules.liline.bean.LiLine;
import com.devplatform.equipment.modules.liline.model.LiLineModel;
import com.devplatform.equipment.modules.liline.service.LiLineService;
import com.devplatform.equipment.modules.listation.bean.LiStation;
import com.devplatform.equipment.modules.listation.service.LiStationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Administrator
 */
@Api(tags = {"线路管理表接口"})
@RestController
@RequestMapping("/liLine")
public class LiLineController extends AbstractController {

  @Autowired private LiLineService liLineService;

  @Autowired private LiStationService liStationService;

  /**
   * 列表页面列表数据获取
   *
   * @param model 承接对象
   * @return
   */
  @ApiOperation(value = "根据条件获取线路管理表分页数据列表", notes = "根据条件获取线路管理表分页数据列表")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, Object>")
  @PostMapping("/list")
  public R list(@RequestParam Map<String, Object> params) {
    PageUtils page = liLineService.queryPage(params, null);
    return R.ok().put("page", page);
  }

  /**
   * 添加
   *
   * @param bean 线路管理表对象
   * @return
   */
  @SysLog("添加线路管理表")
  @SysLogMethod(operation = "新增", blockName = "线路管理", detail = "新增线路管理数据")
  @ApiOperation(value = "新增线路管理表数据", notes = "新增线路管理表数据")
  @PostMapping("/save")
  public R save(@RequestBody @ApiParam(value = "线路管理表实体对象", required = true) LiLine bean) {
    ValidatorUtils.validateEntity(bean);
    bean.setCreateUserId(getUserId());
    bean.setCreateTime(new Date());
    liLineService.save(bean);
    return R.ok();
  }

  /**
   * 修改
   *
   * @param bean 线路管理表对象
   * @return
   */
  @SysLog("修改线路管理表")
  @SysLogMethod(operation = "修改", blockName = "线路管理", detail = "修改线路管理数据")
  @ApiOperation(value = "修改线路管理表数据", notes = "修改线路管理表数据")
  @PostMapping("/update")
  public R update(@RequestBody @ApiParam(value = "线路管理表实体对象", required = true) LiLine bean) {
    ValidatorUtils.validateEntity(bean);
    bean.setUpdateUserId(getUserId());
    bean.setUpdateTime(new Date());
    bean.setSysSign(getUser().getSysSystem().getCode());
    liLineService.update(
        bean,
        new QueryWrapper<LiLine>().eq(StringUtil.checkNotNull(bean.getId()), "id", bean.getId()));
    return R.ok();
  }

  /**
   * 根据ID获取线路管理表对象
   *
   * @param id 对象主键
   * @return
   */
  @ApiOperation(value = "根据ID获取线路管理表对象", notes = "根据ID获取线路管理表对象")
  @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
  @GetMapping("/getId/{id}")
  public R getId(@PathVariable String id) {
    LiLine bean = liLineService.getById(id);
    return R.ok().put("bean", bean);
  }

  /**
   * 根据ID获取线路管理表对象
   *
   * @param id[] 线路管理表对象主键数组
   * @return
   */
  @SysLog("删除线路管理表")
  @SysLogMethod(operation = "删除", blockName = "线路管理", detail = "删除线路数据")
  @ApiOperation(value = "根据ID批量删除线路管理表数据", notes = "根据ID批量删除线路管理表数据")
  @ApiImplicitParam(name = "ids", value = "主键数组", required = true, dataType = "String")
  @PostMapping("/delete")
  public R delete(@RequestBody String[] ids) {
    liLineService.removeByIds(Arrays.asList(ids));
    return R.ok();
  }

  /**
   * 列表数据获取
   *
   * @param model 承接对象
   * @return
   */
  @ApiOperation(value = "根据条件获取线路管理表数据列表", notes = "根据条件获取线路管理表数据列表")
  @ApiImplicitParam(name = "model", value = "参数", required = true, dataType = "LiLineModel")
  @PostMapping("/listAll")
  public R listAll(@RequestBody LiLineModel model) {
    model.setRows(Integer.MAX_VALUE);
    if (StringUtils.isBlank(model.getSort())) {
      model.setSort("order_num");
      model.setOrder("ASC");
    }
    List<LiLine> list = liLineService.queryPageByList(model);
    return R.ok().put("page", getMyPage(list, model));
  }

  /**
   * 获取线路树
   *
   * @param model 承接对象
   * @return
   */
  @ApiOperation(value = "获取线路树", notes = "获取线路树")
  @ApiImplicitParam(name = "model", value = "参数", required = true, dataType = "LiLineModel")
  @PostMapping("/getTreeList")
  public R getTreeList(@RequestBody LiLineModel model) {
    List<LiLine> list = liLineService.getTreeList(model);
    List<Map<String, Object>> tree = new ArrayList<>();
    Map<String, Object> root = new HashMap<>(5);
    root.put("name", "线路");
    root.put("children", list);
    tree.add(root);
    return R.ok().put("tree", tree);
  }

  @ApiOperation(value = "获取线路与站点的级联关系", notes = "获取线路与站点的级联关系")
  @PostMapping("/getTreeListStation")
  public R getTreeListStation() {
    List<LiLine> liLines = liLineService.list(new QueryWrapper<LiLine>().orderByAsc("order_num"));
    List<LiStation> liStations =
        liStationService.list(new QueryWrapper<LiStation>().orderByAsc("order_num"));
    return R.ok().put("liList", liLines).put("lisList", liStations);
  }
}
