package com.devplatform.equipment.modules.liline.dao;

import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.liline.bean.LiLine;
import com.devplatform.equipment.modules.liline.model.LiLineModel;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

/**
 * LiLine Mapper 用于线路管理表的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface LiLineDao extends MyBaseMapper<LiLine> {

  /**
   * 分页查询数量
   *
   * @param model
   * @return
   */
  Integer queryPageByCount(LiLineModel model);

  /**
   * 分页查询数据
   *
   * @param model
   * @return
   */
  List<LiLine> queryPageByList(LiLineModel model);

  /**
   * 获取线路树
   *
   * @param model
   * @return
   */
  List<LiLine> getTreeList(LiLineModel model);
}
