package com.devplatform.equipment.modules.link.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

/** @author */
@ApiModel(value = "联动事件表对象", description = "联动事件表对象")
@TableName("link_event")
public class LinkEvent implements Serializable {
  private static final long serialVersionUID = 1L;

  @ApiModelProperty(value = "主键ID", name = "id")
  @TableId
  private String id;

  @ApiModelProperty(value = "事件名称", name = "eventName")
  private String eventName;

  @ApiModelProperty(value = "事件等级", name = "eventLevel")
  private String eventLevel;

  @ApiModelProperty(value = "是否删除（0=正常 1=已删除）", name = "deleted")
  private Integer deleted;

  @ApiModelProperty(value = "创建人", name = "createUserId")
  private String createUserId;

  @ApiModelProperty(value = "创建时间", name = "createTime")
  private java.util.Date createTime;

  @ApiModelProperty(value = "修改人", name = "updateUserId")
  private String updateUserId;

  @ApiModelProperty(value = "修改时间", name = "updateTime")
  private java.util.Date updateTime;

  @ApiModelProperty(value = "系统标识", name = "sysSign")
  private String sysSign;

  @ApiModelProperty(value = "事件编码", name = "byx1")
  private String byx1;

  @ApiModelProperty(value = "备用项2", name = "byx2")
  private String byx2;

  @ApiModelProperty(value = "备用项3", name = "byx3")
  private String byx3;

  @ApiModelProperty(value = "站点ID", name = "stationId")
  private java.lang.String stationId;

  @TableField(exist = false)
  private String resourceType;

  public String getStationId() {
    return stationId;
  }

  public void setStationId(String stationId) {
    this.stationId = stationId;
  }

  /** 主键id的getter方法 */
  public String getId() {
    return id;
  }
  /** 主键id的setter方法 */
  public void setId(String id) {
    this.id = id;
  }
  /** 事件名称的getter方法 */
  public String getEventName() {
    return eventName;
  }
  /** 事件名称的setter方法 */
  public void setEventName(String eventName) {
    this.eventName = eventName;
  }

  public String getEventLevel() {
    return eventLevel;
  }

  public void setEventLevel(String eventLevel) {
    this.eventLevel = eventLevel;
  }

  /** 是否删除（0=正常 1=已删除）的getter方法 */
  public Integer getDeleted() {
    return deleted;
  }
  /** 是否删除（0=正常 1=已删除）的setter方法 */
  public void setDeleted(Integer deleted) {
    this.deleted = deleted;
  }
  /** 创建人的getter方法 */
  public String getCreateUserId() {
    return createUserId;
  }
  /** 创建人的setter方法 */
  public void setCreateUserId(String createUserId) {
    this.createUserId = createUserId;
  }
  /** 创建时间的getter方法 */
  public java.util.Date getCreateTime() {
    return createTime;
  }
  /** 创建时间的setter方法 */
  public void setCreateTime(java.util.Date createTime) {
    this.createTime = createTime;
  }
  /** 修改人的getter方法 */
  public String getUpdateUserId() {
    return updateUserId;
  }
  /** 修改人的setter方法 */
  public void setUpdateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
  }
  /** 修改时间的getter方法 */
  public java.util.Date getUpdateTime() {
    return updateTime;
  }
  /** 修改时间的setter方法 */
  public void setUpdateTime(java.util.Date updateTime) {
    this.updateTime = updateTime;
  }
  /** 系统标识的getter方法 */
  public String getSysSign() {
    return sysSign;
  }
  /** 系统标识的setter方法 */
  public void setSysSign(String sysSign) {
    this.sysSign = sysSign;
  }
  /** 备用项1的getter方法 */
  public String getByx1() {
    return byx1;
  }
  /** 备用项1的setter方法 */
  public void setByx1(String byx1) {
    this.byx1 = byx1;
  }
  /** 备用项2的getter方法 */
  public String getByx2() {
    return byx2;
  }
  /** 备用项2的setter方法 */
  public void setByx2(String byx2) {
    this.byx2 = byx2;
  }
  /** 备用项3的getter方法 */
  public String getByx3() {
    return byx3;
  }
  /** 备用项3的setter方法 */
  public void setByx3(String byx3) {
    this.byx3 = byx3;
  }

  public String getResourceType() {
    return resourceType;
  }

  public void setResourceType(String resourceType) {
    this.resourceType = resourceType;
  }
}
