package com.devplatform.equipment.modules.link.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.devplatform.common.base.annotation.SysLog;
import com.devplatform.common.base.validator.ValidatorUtils;
import com.devplatform.common.util.PageUtils;
import com.devplatform.common.util.R;
import com.devplatform.equipment.common.annotation.SysLogMethod;
import com.devplatform.equipment.common.utils.AbstractController;
import com.devplatform.equipment.modules.link.bean.LinkAction;
import com.devplatform.equipment.modules.link.bean.LinkResourceAction;
import com.devplatform.equipment.modules.link.service.LinkActionService;
import com.devplatform.equipment.modules.link.service.LinkResourceActionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Administrator
 */
@Api(tags = {"联动动作表接口"})
@RestController
@RequestMapping("/linkAction")
public class LinkActionController extends AbstractController {

  @Autowired private LinkResourceActionService linkResourceActionService;
  @Autowired private LinkActionService linkActionService;

  /**
   * 列表页面列表数据获取
   *
   * @param params 承接对象
   * @return
   */
  @ApiOperation(value = "根据条件获取联动动作表分页数据列表", notes = "根据条件获取联动动作表分页数据列表")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, Object>")
  @PostMapping("/list")
  public R list(@RequestBody Map<String, Object> params) {
    PageUtils page = linkActionService.queryPage(params, null);
    return R.ok().put("page", page);
  }

  /**
   * 添加
   *
   * @param bean 联动动作表对象
   * @return
   */
  @SysLog("添加联动动作表")
  @SysLogMethod(operation = "新增", blockName = "联动动作表", detail = "新增联动动作表数据")
  @ApiOperation(value = "新增联动动作表数据", notes = "新增联动动作表数据")
  @PostMapping("/save")
  public R save(@RequestBody @ApiParam(value = "联动动作表实体对象", required = true) LinkAction bean) {
    String resourceType = bean.getResourceType();

    ValidatorUtils.validateEntity(bean);
    bean.setCreateUserId(getUserId());
    bean.setCreateTime(new Date());
    bean.setSysSign(getUser().getSysSystem().getCode());
    linkActionService.save(bean);

    LinkResourceAction linkResourceAction = new LinkResourceAction();
    linkResourceAction.setActionId(bean.getId());
    linkResourceAction.setResourceType(resourceType);
    linkResourceAction.setSysSign(getUser().getSysSystem().getCode());
    linkResourceAction.setStationId(bean.getStationId());
    linkResourceActionService.save(linkResourceAction);
    return R.ok();
  }

  /**
   * 修改
   *
   * @param bean 联动动作表对象
   * @return
   */
  @SysLog("修改联动动作表")
  @SysLogMethod(operation = "修改", blockName = "联动动作表", detail = "修改联动动作表数据")
  @ApiOperation(value = "修改联动动作表数据", notes = "修改联动动作表数据")
  @PostMapping("/update")
  public R update(@RequestBody @ApiParam(value = "联动动作表实体对象", required = true) LinkAction bean) {
    if (StringUtils.isBlank(bean.getId())) {
      return R.error("参数有误！");
    }
    ValidatorUtils.validateEntity(bean);
    bean.setUpdateUserId(getUserId());
    bean.setUpdateTime(new Date());
    bean.setSysSign(getUser().getSysSystem().getCode());
    linkActionService.update(bean, new QueryWrapper<LinkAction>().eq("id", bean.getId()));
    return R.ok();
  }

  /**
   * 根据ID获取联动动作表对象
   *
   * @param id 对象主键
   * @return
   */
  @ApiOperation(value = "根据ID获取联动动作表对象", notes = "根据ID获取联动动作表对象")
  @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
  @GetMapping("/getId/{id}")
  public R getId(@PathVariable String id) {
    LinkAction bean = linkActionService.getById(id);
    return R.ok().put("bean", bean);
  }

  /**
   * 根据ID获取联动动作表对象
   *
   * @param ids 联动动作表对象主键数组
   * @return
   */
  @SysLog("删除联动动作表")
  @SysLogMethod(operation = "删除", blockName = "联动动作表", detail = "删除联动动作表数据")
  @ApiOperation(value = "根据ID批量删除联动动作表数据", notes = "根据ID批量删除联动动作表数据")
  @ApiImplicitParam(name = "ids", value = "主键数组", required = true, dataType = "String")
  @PostMapping("/delete")
  public R delete(@RequestBody String[] ids) {
    linkActionService.removeByIds(Arrays.asList(ids));
    return R.ok();
  }

  /**
   * 列表页面列表数据获取
   *
   * @param params 承接对象
   * @return
   */
  @ApiOperation(value = "根据条件获取联动动作表分页数据列表", notes = "根据条件获取联动动作表分页数据列表")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, Object>")
  @PostMapping("/actionList")
  public R actionList(@RequestBody Map<String, Object> params) {
    Integer page = (Integer) params.get("page");
    Integer size = (Integer) params.get("size");
    String stationId = (String) params.get("stationId");
    QueryWrapper<LinkAction> queryWrapper =
        new QueryWrapper<LinkAction>()
            .eq("deleted", 0)
            .eq(StringUtils.isNotBlank(stationId), "station_id", stationId)
            .orderByDesc("create_time");
    if (page != null && size != null) {
      IPage<LinkAction> result =
          linkActionService.page(new Page<LinkAction>(page, size), queryWrapper);
      return R.ok().put("page", result);
    } else {
      List<LinkAction> list = linkActionService.list(queryWrapper);
      return R.ok().put("list", list);
    }
  }

  /**
   * 根据ID删除联动动作表数据
   *
   * @param id 联动动作表对象主键
   * @return
   */
  @SysLog("删除联动动作表")
  @SysLogMethod(operation = "删除", blockName = "联动动作表", detail = "删除联动动作表数据")
  @ApiOperation(value = "根据ID删除联动动作表数据", notes = "根据ID删除联动动作表数据")
  @ApiImplicitParam(name = "bean", value = "主键", required = true, dataType = "String")
  @PostMapping("/deleteAction")
  public R deleteAction(String id, String stationId) {
    if (StringUtils.isBlank(id)) {
      return R.error("参数有误！");
    }
    LinkAction linkAction = new LinkAction();
    linkAction.setId(id);
    linkAction.setUpdateTime(new Date());
    linkAction.setUpdateUserId(getUserId());
    linkAction.setDeleted(1);
    linkAction.setSysSign(getUser().getSysSystem().getCode());
    linkActionService.update(linkAction, new QueryWrapper<LinkAction>().eq("id", id));
    return R.ok();
  }
}
