package com.devplatform.equipment.modules.link.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.devplatform.common.base.annotation.SysLog;
import com.devplatform.common.base.validator.ValidatorUtils;
import com.devplatform.common.util.PageUtils;
import com.devplatform.common.util.R;
import com.devplatform.common.util.StringUtil;
import com.devplatform.equipment.common.annotation.SysLogMethod;
import com.devplatform.equipment.common.utils.AbstractController;
import com.devplatform.equipment.modules.link.bean.LinkEvent;
import com.devplatform.equipment.modules.link.bean.LinkLinkageRule;
import com.devplatform.equipment.modules.link.bean.LinkResourceEvent;
import com.devplatform.equipment.modules.link.service.LinkEventService;
import com.devplatform.equipment.modules.link.service.LinkLinkageRuleService;
import com.devplatform.equipment.modules.link.service.LinkResourceEventService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Administrator
 */
@Api(tags = {"联动事件表接口"})
@RestController
@RequestMapping("/linkEvent")
public class LinkEventController extends AbstractController {

  @Autowired private LinkResourceEventService linkResourceEventService;

  @Autowired private LinkEventService linkEventService;

  @Autowired private LinkLinkageRuleService linkageRuleService;

  /**
   * 列表页面列表数据获取
   *
   * @param params 承接对象
   * @return
   */
  @ApiOperation(value = "根据条件获取联动事件表分页数据列表", notes = "根据条件获取联动事件表分页数据列表")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, Object>")
  @PostMapping("/list")
  public R list(@RequestBody Map<String, Object> params) {
    PageUtils page = linkEventService.queryPage(params, null);
    return R.ok().put("page", page);
  }

  /**
   * 添加
   *
   * @param bean 联动事件表对象
   * @return
   */
  @SysLog("添加联动事件表")
  @SysLogMethod(operation = "新增", blockName = "联动事件表", detail = "新增联动事件表数据")
  @ApiOperation(value = "新增联动事件表数据", notes = "新增联动事件表数据")
  @PostMapping("/save")
  public R save(@RequestBody @ApiParam(value = "联动事件表实体对象", required = true) LinkEvent bean) {
    String resourceType = bean.getResourceType();

    ValidatorUtils.validateEntity(bean);
    bean.setCreateUserId(getUserId());
    bean.setCreateTime(new Date());
    bean.setSysSign(getUser().getSysSystem().getCode());
    linkEventService.save(bean);

    LinkResourceEvent linkResourceEvent = new LinkResourceEvent();
    linkResourceEvent.setEventId(bean.getId());
    linkResourceEvent.setResourceType(resourceType);
    linkResourceEvent.setSysSign(getUser().getSysSystem().getCode());
    linkResourceEvent.setStationId(bean.getStationId());
    linkResourceEventService.save(linkResourceEvent);
    return R.ok();
  }

  /**
   * 修改
   *
   * @param bean 联动事件表对象
   * @return
   */
  @SysLog("修改联动事件表")
  @SysLogMethod(operation = "修改", blockName = "联动事件表", detail = "修改联动事件表数据")
  @ApiOperation(value = "修改联动事件表数据", notes = "修改联动事件表数据")
  @PostMapping("/update")
  public R update(@RequestBody @ApiParam(value = "联动事件表实体对象", required = true) LinkEvent bean) {
    if (StringUtils.isBlank(bean.getId())) {
      return R.error("参数有误！");
    }
    ValidatorUtils.validateEntity(bean);
    bean.setUpdateUserId(getUserId());
    bean.setUpdateTime(new Date());
    bean.setSysSign(getUser().getSysSystem().getCode());
    linkEventService.update(bean, new QueryWrapper<LinkEvent>().eq("id", bean.getId()));
    return R.ok();
  }

  /**
   * 根据ID获取联动事件表对象
   *
   * @param id 对象主键
   * @return
   */
  @ApiOperation(value = "根据ID获取联动事件表对象", notes = "根据ID获取联动事件表对象")
  @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
  @GetMapping("/getId/{id}")
  public R getId(@PathVariable String id) {
    LinkEvent bean = linkEventService.getById(id);
    return R.ok().put("bean", bean);
  }

  /**
   * 根据ID获取联动事件表对象
   *
   * @param ids 联动事件表对象主键数组
   * @return
   */
  @SysLog("删除联动事件表")
  @SysLogMethod(operation = "删除", blockName = "联动事件表", detail = "删除联动事件表数据")
  @ApiOperation(value = "根据ID批量删除联动事件表数据", notes = "根据ID批量删除联动事件表数据")
  @ApiImplicitParam(name = "ids", value = "主键数组", required = true, dataType = "String")
  @PostMapping("/delete")
  public R delete(@RequestBody String[] ids) {
    linkEventService.removeByIds(Arrays.asList(ids));
    return R.ok();
  }

  /**
   * 列表页面列表数据获取
   *
   * @param params 承接对象
   * @return
   */
  @ApiOperation(value = "根据条件获取联动事件表分页数据列表", notes = "根据条件获取联动事件表分页数据列表")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, Object>")
  @PostMapping("/eventList")
  public R eventList(@RequestBody Map<String, Object> params) {
    Integer page = (Integer) params.get("page");
    Integer size = (Integer) params.get("size");
    QueryWrapper<LinkEvent> queryWrapper =
        new QueryWrapper<LinkEvent>().eq("deleted", 0).orderByDesc("create_time");
    if (page != null && size != null) {
      IPage<LinkEvent> result =
          linkEventService.page(new Page<LinkEvent>(page, size), queryWrapper);
      return R.ok().put("page", result);
    } else {
      List<LinkEvent> list = linkEventService.list(queryWrapper);
      return R.ok().put("list", list);
    }
  }

  /**
   * 根据ID获取联动动作表对象
   *
   * @param id 联动动作表对象主键
   * @return
   */
  @SysLog("删除联动事件表")
  @SysLogMethod(operation = "删除", blockName = "联动事件表", detail = "删除联动事件表数据")
  @ApiOperation(value = "根据ID删除联动事件表数据", notes = "根据ID删除联动事件表数据")
  @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
  @PostMapping("/deleteEvent")
  public R deleteEvent(String id) {
    Integer countNum =
        linkageRuleService.count(
            new LambdaQueryWrapper<LinkLinkageRule>()
                .eq(LinkLinkageRule::getSjId, id)
                .eq(LinkLinkageRule::getDeleted, 0));
    if (countNum != null && countNum > 0) {
      return R.error("该事件有关联联动规则，不能删除!");
    }

    LinkEvent linkEvent = new LinkEvent();
    linkEvent.setId(id);
    linkEvent.setUpdateUserId(getUserId());
    linkEvent.setUpdateTime(new Date());
    linkEvent.setDeleted(1);
    linkEvent.setSysSign(getUser().getSysSystem().getCode());
    linkEventService.update(
        linkEvent,
        new QueryWrapper<LinkEvent>()
            .eq("id", id));
    return R.ok();
  }
}
