package com.devplatform.equipment.modules.link.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.devplatform.common.base.annotation.SysLog;
import com.devplatform.common.base.validator.ValidatorUtils;
import com.devplatform.common.util.R;
import com.devplatform.common.util.StringUtil;
import com.devplatform.equipment.common.annotation.SysLogMethod;
import com.devplatform.equipment.common.utils.AbstractController;
import com.devplatform.equipment.modules.alarms.service.AlarmsInfoService;
import com.devplatform.equipment.modules.link.bean.LinkLinkageRule;
import com.devplatform.equipment.modules.link.log.service.LinkLogsActionService;
import com.devplatform.equipment.modules.link.log.service.LinkLogsService;
import com.devplatform.equipment.modules.link.service.LinkLinkageRuleService;
import com.devplatform.equipment.modules.link.service.LinkRuleActionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Administrator
 */
@Api(tags = {"联动规则配置接口"})
@RestController
@RequestMapping("/linkLinkageRule")
public class LinkLinkageRuleController extends AbstractController {
  @Autowired private LinkLinkageRuleService linkLinkageRuleService;

  @Autowired private LinkRuleActionService linkRuleActionService;

  @Autowired private AlarmsInfoService alarmsInfoService;

  @Autowired private LinkLogsService linkLogsService;

  @Autowired private LinkLogsActionService linkLogsActionService;

  /**
   * 列表页面列表数据获取
   *
   * @param params 承接对象
   * @return
   */
  @ApiOperation(value = "根据条件获取联动规则配置分页数据列表", notes = "根据条件获取联动规则配置分页数据列表")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, Object>")
  @PostMapping("/list")
  public R list(@RequestParam Map<String, Object> params) {
    String page = (String) params.get("page");
    String limit = (String) params.get("limit");
    Page<Map<String, Object>> pageTask =
        new Page<Map<String, Object>>(Integer.parseInt(page), Integer.parseInt(limit));
    Page<Map<String, Object>> page1 = linkLinkageRuleService.getListByPage(pageTask, params);
    return R.ok().put("page", page1);
  }

  /**
   * 添加
   *
   * @param bean 联动规则配置对象
   * @return
   */
  @SysLog("添加联动规则配置")
  @SysLogMethod(operation = "新增", blockName = "联动规则配置", detail = "新增联动规则配置数据")
  @ApiOperation(value = "新增联动规则配置数据", notes = "新增联动规则配置数据")
  @PostMapping("/save")
  public R save(
      @RequestBody @ApiParam(value = "联动规则配置实体对象", required = true) LinkLinkageRule bean) {
    List<Map<String, Object>> dzList = bean.getDzList();

    Integer count =
        linkLinkageRuleService.count(
            new QueryWrapper<LinkLinkageRule>()
                .eq("resource_id", bean.getResourceId())
                .eq("deleted", "0")
                .eq(
                    StringUtil.checkNotNull(bean.getStationId()),
                    "station_id",
                    bean.getStationId()));
    if (count != null && count > 0) {
      return R.error("该资源点已维护过规则，不能重复维护");
    }

    ValidatorUtils.validateEntity(bean);
    bean.setCreateUserId(getUserId());
    bean.setCreateTime(new Date());
    bean.setUpdateUserId(getUserId());
    bean.setUpdateTime(new Date());
    bean.setSysSign(getUser().getSysSystem().getCode());
    bean.setDzId(null);
    linkLinkageRuleService.save(bean);
    // 往规则与动作中间表存数据(type:1:新增;2:修改)
    linkRuleActionService.addRuleAction(
        1,
        bean.getExecutionMode(),
        dzList,
        bean.getId(),
        getUser().getSysSystem().getCode(),
        bean.getStationId());
    return R.ok();
  }

  /**
   * 修改
   *
   * @param bean 联动规则配置对象
   * @return
   */
  @SysLog("修改联动规则配置")
  @SysLogMethod(operation = "修改", blockName = "联动规则配置", detail = "修改联动规则配置数据")
  @ApiOperation(value = "修改联动规则配置数据", notes = "修改联动规则配置数据")
  @PostMapping("/update")
  public R update(
      @RequestBody @ApiParam(value = "联动规则配置实体对象", required = true) LinkLinkageRule bean) {
    List<Map<String, Object>> dzList = bean.getDzList();

    Integer count =
        linkLinkageRuleService.count(
            new QueryWrapper<LinkLinkageRule>()
                .eq("resource_id", bean.getResourceId())
                .eq("deleted", "0")
                .eq(StringUtil.checkNotNull(bean.getStationId()), "station_id", bean.getStationId())
                .ne("id", bean.getId()));
    if (count != null && count > 0) {
      return R.error("该资源点已维护过规则，不能重复维护");
    }

    ValidatorUtils.validateEntity(bean);
    bean.setSysSign(getUser().getSysSystem().getCode());
    bean.setUpdateUserId(getUserId());
    bean.setUpdateTime(new Date());
    bean.setDzId(null);
    linkLinkageRuleService.update(
        bean,
        new QueryWrapper<LinkLinkageRule>()
            .eq(StringUtil.checkNotNull(bean.getId()), "id", bean.getId())
            .eq(StringUtil.checkNotNull(bean.getStationId()), "station_id", bean.getStationId()));
    // 往规则与动作中间表存数据(type:1:新增;2:修改)
    linkRuleActionService.addRuleAction(
        2,
        bean.getExecutionMode(),
        dzList,
        bean.getId(),
        getUser().getSysSystem().getCode(),
        bean.getStationId());
    return R.ok();
  }

  /**
   * 根据ID获取联动规则配置对象
   *
   * @param id 对象主键
   * @return
   */
  @ApiOperation(value = "根据ID获取联动规则配置对象", notes = "根据ID获取联动规则配置对象")
  @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
  @GetMapping("/getId")
  public R getId(String id, String stationId) {
    LinkLinkageRule bean = linkLinkageRuleService.queryById(id, stationId);
    // 获取该规则绑定的所有动作
    List<Map<String, Object>> list = linkRuleActionService.getListByRuleId(id, stationId);
    return R.ok().put("bean", bean).put("dzList", list);
  }

  /**
   * 根据ID获取联动规则配置对象
   *
   * @return
   */
  @SysLog("删除联动规则配置")
  @SysLogMethod(operation = "删除", blockName = "联动规则配置", detail = "删除联动规则配置数据")
  @ApiOperation(value = "根据ID批量删除联动规则配置数据", notes = "根据ID批量删除联动规则配置数据")
  @PostMapping("/delete")
  public R delete(@RequestBody LinkLinkageRule bean) {
    // 逻辑删除
    ValidatorUtils.validateEntity(bean);
    bean.setUpdateUserId(getUserId());
    bean.setUpdateTime(new Date());
    bean.setDeleted(1);
    bean.setSysSign(getUser().getSysSystem().getCode());
    linkLinkageRuleService.update(
        bean,
        new QueryWrapper<LinkLinkageRule>()
            .eq(StringUtil.checkNotNull(bean.getId()), "id", bean.getId())
            .eq(StringUtil.checkNotNull(bean.getStationId()), "station_id", bean.getStationId()));
    return R.ok();
  }

  /** 根据资源点id获取联动配置信息 */
  @ApiOperation(value = "根据资源点id获取联动配置信息", notes = "根据资源点id获取联动配置信息")
  @GetMapping("/getLinkRule")
  public List<HashMap<String, Object>> getLinkRule(
      @RequestParam("resourceId") String resourceId, @RequestParam("stationId") String stationId) {
    return linkLinkageRuleService.getLinkRule(resourceId, stationId);
  }

  //    /**
  //     * 执行联动规则
  //     */
  //    public R executeLink(String alarmsId) {
  //        //查询报警信息
  //        AlarmsInfo alarmsInfo = alarmsInfoService.queryById(alarmsId);
  //        if (alarmsInfo.getId() == null) return R.error("没有查询到此报警信息");
  //        //根据资源点id查询所有联动规则
  //        String resourceId = alarmsInfo.getResourceId();
  //        if (resourceId == null) return R.error("资源点不存在");
  //        List<HashMap<String, Object>> linkRule = this.getLinkRule(resourceId,null);
  //        //执行联动规则
  //        for (HashMap<String, Object> link : linkRule) {
  //            LinkLogs linkLogs = new LinkLogs();
  //            linkLogs.setRuleActionId(link.get("id").toString());
  //            linkLogs.setAlarmsInfoId(alarmsId);
  //            //默认是系统执行
  //            linkLogs.setCreateUserId("0");
  //            linkLogs.setCreateTime(new Date());
  //            linkLogs.setSysSign(getUser().getSysSystem().getCode());
  //            linkLogsService.save(linkLogs);
  //            if (link.get("executionMode") != null &&
  // link.get("executionMode").toString().equals("2")) {
  //                //同时执行
  //                ThreadPool.threadPoolExecutor.execute(() -> {
  //                    System.err.println(Thread.currentThread().getName() + "\t开始执行动作----->" +
  // link.get("actionInfo"));
  //                    try {
  //                        //模拟执行过程
  //                        Thread.sleep(1000);
  //                    } catch (InterruptedException e) {
  //                        e.printStackTrace();
  //                    }
  //                    //写入日志
  //                    LinkLogsAction linkLogsAction = new LinkLogsAction();
  //                    linkLogsAction.setLogsId(linkLogs.getId());
  //                    linkLogsAction.setActionId(link.get("id").toString());
  //                    linkLogsAction.setCreateTime(new Date());
  //                    linkLogsAction.setActionDescribe("部署在" + link.get("deployLocation") + "的" +
  // link.get("type") + "：" + link.get("resourceName") + "执行了" + link.get("actionInfo"));
  //                    linkLogsAction.setResults(1);
  //                    linkLogsAction.setSysSign(getUser().getSysSystem().getCode());
  //                    insertLog(linkLogsAction);
  //                });
  //            } else {
  //                //顺序执行
  //                System.err.println(Thread.currentThread().getName() + "\t开始执行动作----->" +
  // link.get("actionInfo"));
  //                try {
  //                    //模拟执行过程
  //                    Thread.sleep(1000);
  //                } catch (InterruptedException e) {
  //                    e.printStackTrace();
  //                }
  //                //写入日志
  //                LinkLogsAction linkLogsAction = new LinkLogsAction();
  //                linkLogsAction.setLogsId(linkLogs.getId());
  //                linkLogsAction.setActionId(link.get("id").toString());
  //                linkLogsAction.setCreateTime(new Date());
  //                linkLogsAction.setActionDescribe("部署在" + link.get("deployLocation") + "的" +
  // link.get("type") + "：" + link.get("resourceName") + "执行了" + link.get("actionInfo"));
  //                linkLogsAction.setResults(1);
  //                linkLogsAction.setSysSign(getUser().getSysSystem().getCode());
  //                insertLog(linkLogsAction);
  //            }
  //            //目前只执行一个联动规则
  //            break;
  //        }
  //
  //        return R.ok();
  //    }
  //
  //    public boolean insertLog(LinkLogsAction linkLogsAction) {
  //        return linkLogsActionService.save(linkLogsAction);
  //    }
}
