package com.devplatform.equipment.modules.link.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.devplatform.common.base.annotation.SysLog;
import com.devplatform.common.base.exception.RRException;
import com.devplatform.common.base.validator.ValidatorUtils;
import com.devplatform.common.util.PageUtils;
import com.devplatform.common.util.R;
import com.devplatform.common.util.StringUtil;
import com.devplatform.equipment.common.annotation.SysLogMethod;
import com.devplatform.equipment.common.utils.AbstractController;
import com.devplatform.equipment.modules.link.bean.LinkResourceEvent;
import com.devplatform.equipment.modules.link.model.LinkResourceEventModel;
import com.devplatform.equipment.modules.link.service.LinkResourceEventService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Administrator
 */
@Api(tags = {"资源点与事件关联表接口"})
@RestController
@RequestMapping("/linkResourceEvent")
public class LinkResourceEventController extends AbstractController {

  @Autowired private LinkResourceEventService linkResourceEventService;

  /**
   * 列表页面列表数据获取
   *
   * @param params 承接对象
   * @return
   */
  @ApiOperation(value = "根据条件获取资源点与事件关联表分页数据列表", notes = "根据条件获取资源点与事件关联表分页数据列表")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, Object>")
  @PostMapping("/list")
  public R list(@RequestBody Map<String, Object> params) {
    PageUtils page = linkResourceEventService.queryPage(params, null);
    return R.ok().put("page", page);
  }

  /**
   * 添加
   *
   * @param bean 资源点与事件关联表对象
   * @return
   */
  @SysLog("添加资源点与事件关联表")
  @SysLogMethod(operation = "新增", blockName = "资源点与事件关联表", detail = "新增资源点与事件关联表数据")
  @ApiOperation(value = "新增资源点与事件关联表数据", notes = "新增资源点与事件关联表数据")
  @PostMapping("/save")
  public R save(
      @RequestBody @ApiParam(value = "资源点与事件关联表实体对象", required = true) LinkResourceEvent bean) {
    ValidatorUtils.validateEntity(bean);
    bean.setSysSign(getUser().getSysSystem().getCode());
    linkResourceEventService.save(bean);
    return R.ok();
  }

  /**
   * 修改
   *
   * @param bean 资源点与事件关联表对象
   * @return
   */
  @SysLog("修改资源点与事件关联表")
  @SysLogMethod(operation = "修改", blockName = "资源点与事件关联表", detail = "修改资源点与事件关联表数据")
  @ApiOperation(value = "修改资源点与事件关联表数据", notes = "修改资源点与事件关联表数据")
  @PostMapping("/update")
  public R update(
      @RequestBody @ApiParam(value = "资源点与事件关联表实体对象", required = true) LinkResourceEvent bean) {
    ValidatorUtils.validateEntity(bean);
    bean.setSysSign(getUser().getSysSystem().getCode());
    linkResourceEventService.update(
        bean,
        new QueryWrapper<LinkResourceEvent>()
            .eq(StringUtil.checkNotNull(bean.getId()), "id", bean.getId()));
    return R.ok();
  }

  /**
   * 根据ID获取资源点与事件关联表对象
   *
   * @param id 对象主键
   * @return
   */
  @ApiOperation(value = "根据ID获取资源点与事件关联表对象", notes = "根据ID获取资源点与事件关联表对象")
  @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
  @GetMapping("/getId/{id}")
  public R getId(@PathVariable String id) {
    LinkResourceEvent bean = linkResourceEventService.getById(id);
    return R.ok().put("bean", bean);
  }

  /**
   * 根据ID获取资源点与事件关联表对象
   *
   * @param ids 资源点与事件关联表对象主键数组
   * @return
   */
  @SysLog("删除资源点与事件关联表")
  @SysLogMethod(operation = "删除", blockName = "资源点与事件关联表", detail = "删除资源点与事件关联表数据")
  @ApiOperation(value = "根据ID批量删除资源点与事件关联表数据", notes = "根据ID批量删除资源点与事件关联表数据")
  @ApiImplicitParam(name = "ids", value = "主键数组", required = true, dataType = "String")
  @PostMapping("/delete")
  public R delete(@RequestBody String[] ids) {
    linkResourceEventService.removeByIds(Arrays.asList(ids));
    return R.ok();
  }

  /**
   * 根据ID获取资源点与事件关联表对象
   *
   * @param resourceType 资源类型
   * @return
   */
  @ApiOperation(value = "根据资源类型查询所有事件", notes = "根据资源类型查询所有事件")
  @ApiImplicitParam(name = "resourceType", value = "资源类型", required = true, dataType = "String")
  @GetMapping("/getEventByResourceType")
  public R getEventByResourceType(String resourceType) {
    if (StringUtils.isBlank(resourceType)) {
      return R.error("参数有误！");
    }
    List<Map<String, Object>> list =
        linkResourceEventService.getEventByResourceType(resourceType);
    return R.ok().put("list", list);
  }

  /**
   * 根据ID获取资源点与事件关联表对象
   *
   * @param model
   * @return
   */
  @ApiOperation(value = "根据资源类型查询所有事件", notes = "根据资源类型查询所有事件")
  @ApiImplicitParam(name = "resourceType", value = "资源类型", required = true, dataType = "String")
  @PostMapping("/getPageEventByResourceType")
  public R getPageEventByResourceType(@RequestBody LinkResourceEventModel model) {
    if (StringUtils.isBlank(model.getResourceType())) {
      return R.error("参数有误！");
    }
    List<Map<String, Object>> list = linkResourceEventService.queryPageList(model);
    return R.ok().put("page", getMyPage(list, model));
  }

  @ApiOperation(value = "配置资源类型对应事件", notes = "配置资源类型对应事件")
  @PostMapping("/updateResourceEvent")
  @Transactional(rollbackFor = Exception.class)
  public R updateResourceEvent(@RequestBody Map<String, Object> param) {
    String resourceType = (String) param.get("resource_type");
    ArrayList<String> events = (ArrayList<String>) param.get("events");
    if (StringUtils.isBlank(resourceType)) {
      throw new RRException("参数有误！");
    }
    // 删除全部信息
    linkResourceEventService.remove(
        new QueryWrapper<LinkResourceEvent>()
            .lambda()
            .eq(LinkResourceEvent::getResourceType, resourceType));
    // 添加信息
    ArrayList<LinkResourceEvent> list = new ArrayList<>();
    for (String event : events) {
      LinkResourceEvent entity = new LinkResourceEvent();
      entity.setEventId(event);
      entity.setResourceType(resourceType);
      list.add(entity);
    }
    if (!list.isEmpty()) {
      linkResourceEventService.saveBatch(list);
    }

    return R.ok();
  }
}
