package com.devplatform.equipment.modules.link.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.devplatform.common.base.annotation.SysLog;
import com.devplatform.common.base.validator.ValidatorUtils;
import com.devplatform.common.util.PageUtils;
import com.devplatform.common.util.R;
import com.devplatform.equipment.common.annotation.SysLogMethod;
import com.devplatform.equipment.common.utils.AbstractController;
import com.devplatform.equipment.modules.link.bean.LinkRuleAction;
import com.devplatform.equipment.modules.link.service.LinkRuleActionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Administrator
 */
@Api(tags = {"规则和动作关联表接口"})
@RestController
@RequestMapping("/linkRuleAction")
public class LinkRuleActionController extends AbstractController {

  @Autowired private LinkRuleActionService linkRuleActionService;

  /**
   * 列表页面列表数据获取
   *
   * @param params 承接对象
   * @return
   */
  @ApiOperation(value = "根据条件获取规则和动作关联表分页数据列表", notes = "根据条件获取规则和动作关联表分页数据列表")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, Object>")
  @PostMapping("/list")
  public R list(@RequestParam Map<String, Object> params) {
    PageUtils page = linkRuleActionService.queryPage(params, null);
    return R.ok().put("page", page);
  }

  /**
   * 添加
   *
   * @param bean 规则和动作关联表对象
   * @return
   */
  @SysLog("添加规则和动作关联表")
  @SysLogMethod(operation = "新增", blockName = "规则和动作关联表", detail = "新增规则和动作关联表数据")
  @ApiOperation(value = "新增规则和动作关联表数据", notes = "新增规则和动作关联表数据")
  @PostMapping("/save")
  public R save(
      @RequestBody @ApiParam(value = "规则和动作关联表实体对象", required = true) LinkRuleAction bean) {
    if (StringUtils.isBlank(bean.getId())) {
      return R.error("参数有误！");
    }
    ValidatorUtils.validateEntity(bean);
    linkRuleActionService.save(bean);
    return R.ok();
  }

  /**
   * 修改
   *
   * @param bean 规则和动作关联表对象
   * @return
   */
  @SysLog("修改规则和动作关联表")
  @SysLogMethod(operation = "修改", blockName = "规则和动作关联表", detail = "修改规则和动作关联表数据")
  @ApiOperation(value = "修改规则和动作关联表数据", notes = "修改规则和动作关联表数据")
  @PostMapping("/update")
  public R update(
      @RequestBody @ApiParam(value = "规则和动作关联表实体对象", required = true) LinkRuleAction bean) {
    if (StringUtils.isBlank(bean.getId())) {
      return R.error("参数有误！");
    }
    ValidatorUtils.validateEntity(bean);
    bean.setSysSign(getUser().getSysSystem().getCode());
    linkRuleActionService.update(bean, new QueryWrapper<LinkRuleAction>().eq("id", bean.getId()));
    return R.ok();
  }

  /**
   * 根据ID获取规则和动作关联表对象
   *
   * @param id 对象主键
   * @return
   */
  @ApiOperation(value = "根据ID获取规则和动作关联表对象", notes = "根据ID获取规则和动作关联表对象")
  @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
  @GetMapping("/getId/{id}")
  public R getId(@PathVariable String id) {
    LinkRuleAction bean = linkRuleActionService.getById(id);
    return R.ok().put("bean", bean);
  }

  /**
   * 根据ID获取规则和动作关联表对象
   *
   * @param ids 规则和动作关联表对象主键数组
   * @return
   */
  @SysLog("删除规则和动作关联表")
  @SysLogMethod(operation = "删除", blockName = "规则和动作关联表", detail = "删除规则和动作关联表数据")
  @ApiOperation(value = "根据ID批量删除规则和动作关联表数据", notes = "根据ID批量删除规则和动作关联表数据")
  @ApiImplicitParam(name = "ids", value = "主键数组", required = true, dataType = "String")
  @PostMapping("/delete")
  public R delete(@RequestBody String[] ids) {
    linkRuleActionService.removeByIds(Arrays.asList(ids));
    return R.ok();
  }

  /**
   * 根据规则id查询所属的动作
   *
   * @param ruleId 规则id
   * @return
   */
  @ApiOperation(value = "根据规则id查询所属的动作", notes = "根据规则id查询所属的动作")
  @ApiImplicitParam(name = "ruleId", value = "规则id", required = true, dataType = "String")
  @GetMapping("/getListByRuleId")
  public R getListByRuleId(String ruleId, String stationId) {
    List<Map<String, Object>> dzList = linkRuleActionService.getListByRuleId(ruleId, stationId);
    return R.ok().put("list", dzList);
  }
}
