package com.devplatform.equipment.modules.link.dao;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.link.bean.LinkLinkageRule;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

/**
 * LinkLinkageRule Mapper 用于联动规则配置的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface LinkLinkageRuleDao extends MyBaseMapper<LinkLinkageRule> {
  /**
   * 查询联动规则配置分页数据
   * @param page
   * @param params
   * @return
   */
  Page<Map<String, Object>> getListByPage(
      @Param("page") Page<Map<String, Object>> page, @Param("params") Map<String, Object> params);

  /**
   * 根据id查询联动规则
   * @param id
   * @param stationId
   * @return
   */
  LinkLinkageRule queryById(String id, String stationId);

  /**
   * 根据资源点id查询联动规则
   * @param resourceId
   * @param stationId
   * @return
   */
  List<HashMap<String, Object>> getLinkRule(
      @Param("resourceId") String resourceId, @Param("stationId") String stationId);
}
