package com.devplatform.equipment.modules.link.dao;

import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.link.bean.LinkResourceAction;
import com.devplatform.equipment.modules.link.model.LinkResourceActionModel;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

/**
 * LinkResourceActionDao Mapper 用于事件与动作关联表的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface LinkResourceActionDao extends MyBaseMapper<LinkResourceAction> {

  /**
   * 根据资源点类型查询动作
   * @param resourceType
   * @param stationId
   * @return
   */
  List<Map<String, Object>> getActionByResourceId(String resourceType, String stationId);

  /**
   * 查询动作分页数量
   * @param model
   * @return
   */
  Integer queryPageByCount(@Param("model") LinkResourceActionModel model);

  /**
   * 查询动作分页数据
   * @param model
   * @return
   */
  List<Map<String, Object>> queryPageList(@Param("model") LinkResourceActionModel model);
}
