package com.devplatform.equipment.modules.link.dao;

import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.link.bean.LinkResourceEvent;
import com.devplatform.equipment.modules.link.model.LinkResourceEventModel;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

/**
 * LinkResourceEvent Mapper 用于资源点与事件关联表的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface LinkResourceEventDao extends MyBaseMapper<LinkResourceEvent> {

  /**
   * 根据资源点类型查询事件
   * @param resourceType
   * @return
   */
  List<Map<String, Object>> getEventByResourceType(String resourceType);

  /**
   * 查询事件分页数据
   * @param model
   * @return
   */
  List<Map<String, Object>> queryPageList(@Param("model") LinkResourceEventModel model);

  /**
   * 查询事件分页数量
   * @param model
   * @return
   */
  Integer queryPageByCount(@Param("model") LinkResourceEventModel model);
}
