package com.devplatform.equipment.modules.link.dao;

import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.link.bean.LinkRuleAction;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

/**
 * LinkRuleAction Mapper 用于规则和动作关联表的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface LinkRuleActionDao extends MyBaseMapper<LinkRuleAction> {
  /**
   * 根据规则id查询数据
   * @param ruleId
   * @param stationId
   * @return
   */
  List<Map<String, Object>> getListByRuleId(
      @Param("ruleId") String ruleId, @Param("stationId") String stationId);
}
