package com.devplatform.equipment.modules.link.log.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.devplatform.common.base.annotation.SysLog;
import com.devplatform.common.base.exception.RRException;
import com.devplatform.common.base.validator.ValidatorUtils;
import com.devplatform.common.util.PageUtils;
import com.devplatform.common.util.R;
import com.devplatform.common.util.StringUtil;
import com.devplatform.equipment.common.annotation.SysLogMethod;
import com.devplatform.equipment.common.utils.AbstractController;
import com.devplatform.equipment.common.utils.Constants;
import com.devplatform.equipment.modules.link.log.bean.LinkAttachment;
import com.devplatform.equipment.modules.link.log.service.LinkAttachmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import sun.misc.BASE64Encoder;

/**
 * @author Administrator
 */
@Api(tags = {"联动生成附件表接口"})
@RestController
@RequestMapping("/linkAttachment")
public class LinkAttachmentController extends AbstractController {

    @Autowired
    private LinkAttachmentService linkAttachmentService;

    /**
     * 列表页面列表数据获取
     *
     * @param params 承接对象
     * @return
     */
    @ApiOperation(value = "根据条件获取联动生成附件表分页数据列表", notes = "根据条件获取联动生成附件表分页数据列表")
    @ApiImplicitParam(
            name = "params",
            value = "参数",
            required = true,
            dataType = "Map<String, Object>")
    @PostMapping("/list")
    public R list(@RequestParam Map<String, Object> params) {
        PageUtils page = linkAttachmentService.queryPage(params, null);
        return R.ok().put("page", page);
    }

    /**
     * 添加
     *
     * @param bean 联动生成附件表对象
     * @return
     */
    @SysLog("添加联动生成附件表")
    @SysLogMethod(operation = "新增", blockName = "联动生成附件表", detail = "新增联动生成附件表数据")
    @ApiOperation(value = "新增联动生成附件表数据", notes = "新增联动生成附件表数据")
    @PostMapping("/save")
    public R save(
            @RequestBody @ApiParam(value = "联动生成附件表实体对象", required = true) LinkAttachment bean) {
        ValidatorUtils.validateEntity(bean);
        bean.setCreateUserId(getUserId());
        bean.setCreateTime(new Date());
        bean.setSysSign(getUser().getSysSystem().getCode());
        linkAttachmentService.save(bean);
        return R.ok();
    }

    /**
     * 修改
     *
     * @param bean 联动生成附件表对象
     * @return
     */
    @SysLog("修改联动生成附件表")
    @SysLogMethod(operation = "修改", blockName = "联动生成附件表", detail = "修改联动生成附件表数据")
    @ApiOperation(value = "修改联动生成附件表数据", notes = "修改联动生成附件表数据")
    @PostMapping("/update")
    public R update(
            @RequestBody @ApiParam(value = "联动生成附件表实体对象", required = true) LinkAttachment bean) {
        ValidatorUtils.validateEntity(bean);
        bean.setUpdateUserId(getUserId());
        bean.setUpdateTime(new Date());
        bean.setSysSign(getUser().getSysSystem().getCode());
        linkAttachmentService.update(
                bean,
                new QueryWrapper<LinkAttachment>()
                        .eq(StringUtil.checkNotNull(bean.getId()), "id", bean.getId()));
        return R.ok();
    }

    /**
     * 根据ID获取联动生成附件表对象
     *
     * @param id 对象主键
     * @return
     */
    @ApiOperation(value = "根据ID获取联动生成附件表对象", notes = "根据ID获取联动生成附件表对象")
    @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
    @GetMapping("/getId/{id}")
    public R getId(@PathVariable String id) {
        LinkAttachment bean = linkAttachmentService.getById(id);
        return R.ok().put("bean", bean);
    }

    /**
     * 根据ID获取联动生成附件表对象
     *
     * @param ids 联动生成附件表对象主键数组
     * @return
     */
    @SysLog("删除联动生成附件表")
    @SysLogMethod(operation = "删除", blockName = "联动生成附件表", detail = "删除联动生成附件表数据")
    @ApiOperation(value = "根据ID批量删除联动生成附件表数据", notes = "根据ID批量删除联动生成附件表数据")
    @ApiImplicitParam(name = "ids", value = "主键数组", required = true, dataType = "String")
    @PostMapping("/delete")
    public R delete(@RequestBody String[] ids) {
        linkAttachmentService.removeByIds(Arrays.asList(ids));
        return R.ok();
    }

    /**
     * 根据ID获取联动生成附件表对象
     */
    @ApiOperation(value = "根据ID获取联动生成附件表对象", notes = "根据ID获取联动生成附件表对象")
    @ApiImplicitParam(name = "linkLogsActionId", value = "主键", required = true, dataType = "String")
    @GetMapping("/getAttachment")
    public R getAttachment(String linkLogsActionId) {
        if (StringUtils.isBlank(linkLogsActionId)) {
            throw new RRException("参数有误!");
        }
        List<LinkAttachment> list =
                linkAttachmentService.list(
                        new QueryWrapper<LinkAttachment>()
                                .lambda()
                                .eq(LinkAttachment::getLinkLogsActionId, linkLogsActionId));
        return R.ok().put("list", list);
    }

    /**
     * 根据ID下载附件
     */
    @ApiOperation(value = "下载附件", notes = "下载附件")
    @GetMapping("/downloadFile")
    public void downloadFile(String id, HttpServletRequest request, HttpServletResponse response) {
        // 获取文件信息
        LinkAttachment entity = linkAttachmentService.getById(id);
        String path = entity.getPath();
        if (StringUtils.isBlank(path)) {
            return;
        }
        InputStream inputStream = null;
        OutputStream out = null;
        BufferedInputStream bis = null;
        try {
            // 根据文件在服务器的路径读取该文件转化为流
            URL url = new URL(path);
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5 * 1000);
            // 获取mime文件类型
            String contentType = conn.getContentType();
            inputStream = conn.getInputStream();
            bis = new BufferedInputStream(inputStream);
            // 创建一个Buffer字符串
            byte[] buffer = new byte[1024];
            StringBuffer sb = new StringBuffer();
            sb.append(entity.getName()).append(".").append(entity.getFileType());
            String fileName = sb.toString();
            // 设置文件ContentType类型
            response.setContentType(contentType);
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            final String userAgent = request.getHeader("USER-AGENT");
            if (userAgent.contains(Constants.FIREFOX)) {
                // 是火狐浏览器，使用BASE64编码
                fileName = "=?utf-8?b?" + new BASE64Encoder().encode(fileName.getBytes("utf-8")) + "?=";
            } else {
                // 给文件名进行URL编码
                // URLEncoder.encode()需要两个参数，第一个参数时要编码的字符串，第二个是编码所采用的字符集
                fileName = URLEncoder.encode(fileName, "utf-8");
            }
            // 设置文件头：最后一个参数是设置下载文件名（设置编码格式防止下载的文件名乱码）
            response.setHeader("Content-Disposition", "attachment;fileName=" + fileName);
            out = response.getOutputStream();
            int b = 0;
            while ((b = bis.read(buffer)) != -1) {
                // 写到输出流(out)中
                out.write(buffer, 0, b);
                out.flush();
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                out.close();
                bis.close();
                inputStream.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * 根据ID批量下载附件
     */
    @ApiOperation(value = "批量下载附件", notes = "批量下载附件")
    @GetMapping(value = "/downloadAllFile")
    public void downloadAllFile(HttpServletRequest request, HttpServletResponse response, String id, String urlPath) {
        linkAttachmentService.downloadAllFile(request, response, id, urlPath);
    }

    /**
     * 根据报警id查询附件表信息
     */
    @ApiOperation(value = "根据报警id查询附件表信息", notes = "根据报警id查询附件表信息")
    @GetMapping(value = "/queryListByAlarmsId/{alarmsId}")
    public R queryListByAlarmsId(@PathVariable("alarmsId") String alarmsId) {
        List<LinkAttachment> list = linkAttachmentService.queryListByAlarmsId(alarmsId);
        return R.ok().put("list", list);
    }
}
