package com.devplatform.equipment.modules.link.log.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.devplatform.common.base.annotation.SysLog;
import com.devplatform.common.base.validator.ValidatorUtils;
import com.devplatform.common.util.PageUtils;
import com.devplatform.common.util.R;
import com.devplatform.common.util.StringUtil;
import com.devplatform.equipment.common.annotation.SysLogMethod;
import com.devplatform.equipment.common.utils.AbstractController;
import com.devplatform.equipment.modules.link.log.bean.LinkLogsAction;
import com.devplatform.equipment.modules.link.log.service.LinkLogsActionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Administrator
 */
@Api(tags = {"联动规则日志动作执行记录表接口"})
@RestController
@RequestMapping("/linkLogsAction")
public class LinkLogsActionController extends AbstractController {

  @Autowired private LinkLogsActionService linkLogsActionService;

  /**
   * 列表页面列表数据获取
   *
   * @param params 承接对象
   * @return
   */
  @ApiOperation(value = "根据条件获取联动规则日志动作执行记录表分页数据列表", notes = "根据条件获取联动规则日志动作执行记录表分页数据列表")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, Object>")
  @PostMapping("/list")
  public R list(@RequestParam Map<String, Object> params) {
    PageUtils page = linkLogsActionService.queryPage(params, null);
    return R.ok().put("page", page);
  }

  /**
   * 添加
   *
   * @param bean 联动规则日志动作执行记录表对象
   * @return
   */
  @SysLog("添加联动规则日志动作执行记录表")
  @SysLogMethod(operation = "新增", blockName = "联动规则日志动作执行记录表", detail = "新增联动规则日志动作执行记录表数据")
  @ApiOperation(value = "新增联动规则日志动作执行记录表数据", notes = "新增联动规则日志动作执行记录表数据")
  @PostMapping("/save")
  public R save(
      @RequestBody @ApiParam(value = "联动规则日志动作执行记录表实体对象", required = true) LinkLogsAction bean) {
    ValidatorUtils.validateEntity(bean);
    bean.setCreateTime(new Date());
    bean.setSysSign(getUser().getSysSystem().getCode());
    linkLogsActionService.save(bean);
    return R.ok();
  }

  /**
   * 修改
   *
   * @param bean 联动规则日志动作执行记录表对象
   * @return
   */
  @SysLog("修改联动规则日志动作执行记录表")
  @SysLogMethod(operation = "修改", blockName = "联动规则日志动作执行记录表", detail = "修改联动规则日志动作执行记录表数据")
  @ApiOperation(value = "修改联动规则日志动作执行记录表数据", notes = "修改联动规则日志动作执行记录表数据")
  @PostMapping("/update")
  public R update(
      @RequestBody @ApiParam(value = "联动规则日志动作执行记录表实体对象", required = true) LinkLogsAction bean) {
    ValidatorUtils.validateEntity(bean);
    bean.setSysSign(getUser().getSysSystem().getCode());
    linkLogsActionService.update(
        bean,
        new QueryWrapper<LinkLogsAction>()
            .eq(StringUtil.checkNotNull(bean.getId()), "id", bean.getId()));
    return R.ok();
  }

  /**
   * 根据ID获取联动规则日志动作执行记录表对象
   *
   * @param id 对象主键
   * @return
   */
  @ApiOperation(value = "根据ID获取联动规则日志动作执行记录表对象", notes = "根据ID获取联动规则日志动作执行记录表对象")
  @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
  @GetMapping("/getId/{id}")
  public R getId(@PathVariable String id) {
    LinkLogsAction bean = linkLogsActionService.getById(id);
    return R.ok().put("bean", bean);
  }

  /**
   * 根据ID获取联动规则日志动作执行记录表对象
   *
   * @param ids 联动规则日志动作执行记录表对象主键数组
   * @return
   */
  @SysLog("删除联动规则日志动作执行记录表")
  @SysLogMethod(operation = "删除", blockName = "联动规则日志动作执行记录表", detail = "删除联动规则日志动作执行记录表数据")
  @ApiOperation(value = "根据ID批量删除联动规则日志动作执行记录表数据", notes = "根据ID批量删除联动规则日志动作执行记录表数据")
  @ApiImplicitParam(name = "ids", value = "主键数组", required = true, dataType = "String")
  @PostMapping("/delete")
  public R delete(@RequestBody String[] ids) {
    linkLogsActionService.removeByIds(Arrays.asList(ids));
    return R.ok();
  }

  /**
   * 根据条件获取联动规则日志动作执行记录表分页数据列表
   *
   * @param params 承接对象
   * @return
   */
  @ApiOperation(value = "根据条件获取联动规则日志动作执行记录表分页数据列表", notes = "根据条件获取联动规则日志动作执行记录表分页数据列表")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, Object>")
  @PostMapping("/getList")
  public R getList(@RequestBody Map<String, Object> params) {
    List<HashMap<String, Object>> list = linkLogsActionService.getList(params);
    return R.ok().put("list", list);
  }
}
