package com.devplatform.equipment.modules.link.log.dao;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.link.log.bean.LinkLogs;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

/**
 * LinkLogs Mapper 用于联动日志表的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface LinkLogsDao extends MyBaseMapper<LinkLogs> {

  /**
   * 查询联动日志
   * @param params
   * @return
   */
  List<Map<String, Object>> getList(Map<String, Object> params);

  /**
   * 查询联动日志分页数据
   * @param page
   * @param params
   * @return
   */
  Page<Map<String, Object>> getListPage(
      @Param("page") Page<Map<String, Object>> page, @Param("params") Map<String, Object> params);
}
