package com.devplatform.equipment.modules.link.log.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.devplatform.common.base.exception.RRException;
import com.devplatform.common.service.impl.MyBaseServiceImpl;
import com.devplatform.equipment.common.utils.Constants;
import com.devplatform.equipment.modules.link.log.bean.LinkAttachment;
import com.devplatform.equipment.modules.link.log.dao.LinkAttachmentDao;
import com.devplatform.equipment.modules.link.log.service.LinkAttachmentService;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.io.IOUtils;
import org.springframework.stereotype.Service;
import sun.misc.BASE64Encoder;

/**
 * 联动生成附件表的service接口实现类 <br>
 * <b>功能：</b>LinkAttachmentServiceImpl<br>
 *
 * @author 代码生成器产生
 */
@Service("linkAttachmentService")
public class LinkAttachmentServiceImpl extends MyBaseServiceImpl<LinkAttachmentDao, LinkAttachment>
        implements LinkAttachmentService {

    /**
     * 根据地址获得数据的输入流
     *
     * @param strUrl 网络连接地址
     * @return url的输入流
     */
    public static InputStream getInputStreamByUrl(String strUrl) {
        HttpURLConnection conn = null;
        try {
            URL url = new URL(strUrl);
            conn = (HttpURLConnection) url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(20 * 1000);
            final ByteArrayOutputStream output = new ByteArrayOutputStream();
            IOUtils.copy(conn.getInputStream(), output);
            return new ByteArrayInputStream(output.toByteArray());
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }

    @Override
    public void downloadAllFile(HttpServletRequest request, HttpServletResponse response, String id, String urlPath) {
        StringBuilder sb = new StringBuilder();
        sb.append("动作附件-").append(new SimpleDateFormat("yyyyMMdd").format(new Date())).append(".zip");
        String downloadName = sb.toString();

        OutputStream outputStream = null;
        ZipOutputStream zos = null;
        String fileName = "";
        try {
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            response.setContentType("multipart/form-data");
            final String userAgent = request.getHeader("USER-AGENT");
            if (userAgent.contains(Constants.FIREFOX)) {
                // 是火狐浏览器，使用BASE64编码
                fileName = "=?utf-8?b?" + new BASE64Encoder().encode(downloadName.getBytes("utf-8")) + "?=";
            } else {
                // 给文件名进行URL编码
                // URLEncoder.encode()需要两个参数，第一个参数时要编码的字符串，第二个是编码所采用的字符集
                fileName = URLEncoder.encode(downloadName, "utf-8");
            }
            // 设置文件头：最后一个参数是设置下载文件名（设置编码格式防止下载的文件名乱码）
            response.setHeader("Content-Disposition", "attachment;fileName=" + fileName);
            outputStream = response.getOutputStream();
            zos = new ZipOutputStream(outputStream);
            // 将文件流写入zip中
            downloadTolocal(zos, id, urlPath);
            outputStream.flush();

        } catch (IOException e) {
            throw new RRException("下载文件名编码时出现错误.", e);
        } finally {
            if (zos != null) {
                try {
                    zos.close();
                } catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                } catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    @Override
    public List<LinkAttachment> queryListByAlarmsId(String alarmsId) {
        return baseMapper.queryListByAlarmsId(alarmsId);
    }

    private void downloadTolocal(ZipOutputStream zos, String id, String urlPath) throws IOException {
        // 获取文件信息（此处为业务代码，可根据自己的需要替换）
        List<LinkAttachment> list =
                this.list(
                        new QueryWrapper<LinkAttachment>()
                                .lambda()
                                .eq(LinkAttachment::getLinkLogsActionId, id));
        for (LinkAttachment linkAttachment : list) {
            StringBuilder sb = new StringBuilder();
            sb.append(linkAttachment.getName()).append(".").append(linkAttachment.getFileType());
            // 文件名称（带后缀）
            String fileName = sb.toString();
            InputStream is = null;
            BufferedInputStream in = null;
            byte[] buffer = new byte[1024];
            // 创建zip实体（一个文件对应一个ZipEntry）
            ZipEntry entry = new ZipEntry(fileName);
            try {
                // 获取需要下载的文件流
                String path = urlPath + linkAttachment.getPath();
                is = getInputStreamByUrl(path);
                in = new BufferedInputStream(is);
                zos.putNextEntry(entry);
                // 文件流循环写入ZipOutputStream
                int len;
                while ((len = in.read(buffer)) != -1) {
                    zos.write(buffer, 0, len);
                }
            } catch (Exception e) {
                throw new RRException("xxx--下载全部附件--压缩文件出错", e);
            } finally {
                zos.closeEntry();
                if (in != null) {
                    in.close();
                }
                if (is != null) {
                    is.close();
                }
            }
        }
    }
}
