package com.devplatform.equipment.modules.link.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.devplatform.common.service.MyBaseService;
import com.devplatform.equipment.modules.link.bean.LinkLinkageRule;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 联动规则配置的service接口 <br>
 * <b>功能：</b>LinkLinkageRuleService<br>
 *
 * @author 代码生成器产生
 */
public interface LinkLinkageRuleService extends MyBaseService<LinkLinkageRule> {
  /**
   * 查询联动规则配置数据
   * @param page
   * @param params
   * @return
   */
  Page<Map<String, Object>> getListByPage(
      Page<Map<String, Object>> page, Map<String, Object> params);

  /**
   * 根据id查询联动规则
   * @param id
   * @param stationId
   * @return
   */
  LinkLinkageRule queryById(String id, String stationId);

  /**
   * 根据资源点id查询联动规则
   * @param resourceId
   * @param stationId
   * @return
   */
  List<HashMap<String, Object>> getLinkRule(String resourceId, String stationId);
}
