package com.devplatform.equipment.modules.link.service.impl;

import com.devplatform.common.service.impl.MyBaseServiceImpl;
import com.devplatform.equipment.modules.link.bean.LinkResourceEvent;
import com.devplatform.equipment.modules.link.dao.LinkResourceEventDao;
import com.devplatform.equipment.modules.link.model.LinkResourceEventModel;
import com.devplatform.equipment.modules.link.service.LinkResourceEventService;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

/**
 * 资源点与事件关联表的service接口实现类 <br>
 * <b>功能：</b>LinkResourceEventServiceImpl<br>
 *
 * @author 代码生成器产生
 */
@Service("linkResourceEventService")
public class LinkResourceEventServiceImpl
    extends MyBaseServiceImpl<LinkResourceEventDao, LinkResourceEvent>
    implements LinkResourceEventService {

  @Override
  public List<Map<String, Object>> getEventByResourceType(String resourceType) {
    return baseMapper.getEventByResourceType(resourceType);
  }

  @Override
  public List<Map<String, Object>> queryPageList(LinkResourceEventModel model) {
    Integer rowCount = baseMapper.queryPageByCount(model);
    model.getPager().setRowCount(rowCount);
    return baseMapper.queryPageList(model);
  }
}
