package com.devplatform.equipment.modules.link.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.devplatform.common.service.impl.MyBaseServiceImpl;
import com.devplatform.common.util.StringUtil;
import com.devplatform.equipment.common.utils.Constants;
import com.devplatform.equipment.modules.link.bean.LinkRuleAction;
import com.devplatform.equipment.modules.link.dao.LinkRuleActionDao;
import com.devplatform.equipment.modules.link.service.LinkRuleActionService;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

/**
 * 规则和动作关联表的service接口实现类 <br>
 * <b>功能：</b>LinkRuleActionServiceImpl<br>
 *
 * @author 代码生成器产生
 */
@Service("linkRuleActionService")
public class LinkRuleActionServiceImpl extends MyBaseServiceImpl<LinkRuleActionDao, LinkRuleAction>
    implements LinkRuleActionService {

  @Override
  public List<Map<String, Object>> getListByRuleId(String ruleId, String stationId) {
    return baseMapper.getListByRuleId(ruleId, stationId);
  }

  @Override
  public void addRuleAction(
      Integer type,
      Integer executionMode,
      List<Map<String, Object>> dzList,
      String ruleId,
      String sysSign,
      String stationId) {
      // 如果是修改,则先删除中间表中当前规则的数据，再添加
    if (type == Constants.INT_2) {
      baseMapper.delete(
          new QueryWrapper<LinkRuleAction>()
              .eq("rule_id", ruleId)
              .eq(StringUtil.checkNotNull(stationId), "station_id", stationId));
    }
    for (int i = 0; i < dzList.size(); i++) {
      LinkRuleAction lra = new LinkRuleAction();
      lra.setRuleId(ruleId);
      lra.setActionId((String) dzList.get(i).get("action_id"));

      lra.setResourceId((String) dzList.get(i).get("resourceId"));
      lra.setParamsName1((String) dzList.get(i).get("params_name1"));
      lra.setParamsValue1(dzList.get(i).get("params_value1") + "");
      lra.setParamsName2((String) dzList.get(i).get("params_name2"));
      lra.setParamsValue2(dzList.get(i).get("params_value2") + "");
      lra.setStationId(stationId);
      lra.setSysSign(sysSign);
      //执行模式(1顺序执行，2同时执行);如果执行模式为顺序，按传过来的顺序赋值排序值，否则都为1
      lra.setSortValue(i + 1);
      baseMapper.insert(lra);
    }
  }
}
