package com.devplatform.equipment.modules.liresource.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.devplatform.common.base.annotation.SysLog;
import com.devplatform.common.base.validator.ValidatorUtils;
import com.devplatform.common.util.R;
import com.devplatform.common.util.StringUtil;
import com.devplatform.equipment.common.annotation.SysLogMethod;
import com.devplatform.equipment.common.utils.AbstractController;
import com.devplatform.equipment.common.utils.Constants;
import com.devplatform.equipment.modules.invadedefence.bean.InvadeDefence;
import com.devplatform.equipment.modules.invadedefence.service.InvadeDefenceService;
import com.devplatform.equipment.modules.invadedefenceresource.service.InvadeDefenceResourceService;
import com.devplatform.equipment.modules.liline.bean.LiLine;
import com.devplatform.equipment.modules.liline.model.LiLineModel;
import com.devplatform.equipment.modules.liline.service.LiLineService;
import com.devplatform.equipment.modules.liresource.bean.LiResource;
import com.devplatform.equipment.modules.liresource.model.LiResourceModel;
import com.devplatform.equipment.modules.liresource.service.LiResourceService;
import com.devplatform.equipment.modules.liresourcecamera.bean.LiResourceCamera;
import com.devplatform.equipment.modules.liresourcecamera.service.LiResourceCameraService;
import com.devplatform.equipment.modules.listation.bean.LiStation;
import com.devplatform.equipment.modules.listation.model.LiStationModel;
import com.devplatform.equipment.modules.listation.service.LiStationService;
import com.devplatform.equipment.modules.listationmap.bean.LiStationMap;
import com.devplatform.equipment.modules.listationmap.model.LiStationMapModel;
import com.devplatform.equipment.modules.listationmap.service.LiStationMapService;
import com.devplatform.equipment.modules.sysdictionary.bean.SysDictionary;
import com.devplatform.equipment.modules.sysdictionary.service.SysDictionaryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Administrator
 */
@Api(tags = {"资源点管理表接口"})
@RestController
@RequestMapping("/liResource")
public class LiResourceController extends AbstractController {

  @Autowired private LiResourceService liResourceService;
  @Autowired private LiLineService liLineService;
  @Autowired private LiStationService liStationService;
  @Autowired private LiStationMapService liStationMapService;
  @Autowired private SysDictionaryService sysDictionaryService;
  @Autowired private LiResourceCameraService liResourceCameraService;
  @Autowired private InvadeDefenceResourceService invadeDefenceResourceService;
  @Autowired private InvadeDefenceService invadeDefenceService;

  /**
   * 根据站点id和子系统编码获取所有资源点名字
   *
   * @param params 承接对象 stationId 站点Id subCode 子系统编码
   * @return
   */
  @ApiOperation(value = "根据站点id获取所有资源点名字", notes = "根据站点id获取所有资源点名字")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, String>")
  @PostMapping("/getAllResourceNameList")
  public R getAllResourceNameList(@RequestBody Map<String, String> params) {
    LiResourceModel model = new LiResourceModel();

    // 站点ID
    if (StringUtil.checkNotNull(params.get(Constants.STATION_ID))) {
      model.setStationId(params.get("stationId"));
    }
    // 子系统编码
    if (StringUtil.checkNotNull(params.get(Constants.SUB_CODE))) {
      model.setSubCode(params.get("subCode"));
    }

    if (StringUtils.isBlank(model.getSort())) {
      model.setSort("create_time");
      model.setOrder("DESC");
    }
    List<String> list = liResourceService.getAllResourceNameList(model);
    return R.ok().put("list", list);
  }

  /**
   * 列表页面列表数据获取
   *
   * @param model 承接对象
   * @return
   */
  @ApiOperation(value = "根据条件获取资源点管理表分页数据列表", notes = "根据条件获取资源点管理表分页数据列表")
  @ApiImplicitParam(name = "model", value = "参数", required = true, dataType = "LiResourceModel")
  @PostMapping("/list")
  public R list(@RequestBody LiResourceModel model) {
    if (StringUtils.isBlank(model.getSort())) {
      model.setSort("create_time");
      model.setOrder("DESC");
    }
    List<LiResource> list = liResourceService.queryPageByList(model);
    return R.ok().put("page", getMyPage(list, model));
  }

  /**
   * 添加
   *
   * @param bean 资源点管理表对象
   * @return
   */
  @ApiOperation(value = "新增资源点管理表数据", notes = "新增资源点管理表数据")
  @PostMapping("/save")
  public R save(@RequestBody @ApiParam(value = "资源点管理表实体对象", required = true) LiResource bean) {
    ValidatorUtils.validateEntity(bean);
    bean.setCreateUserId(getUserId());
    bean.setCreateTime(new Date());
    bean.setOperatorId(getUserId());
    bean.setOperatorName(getUser().getUsername());
    // 资源点状态(0=离线-默认，1=在线)
    bean.setByx2("0");
    // 布防状态(0=撤防，1=布防-默认)
    bean.setByx3("1");
    bean.setSysSign(getUser().getSysSystem().getCode());
    liResourceService.save(bean);
    return R.ok();
  }

  /**
   * 修改
   *
   * @param bean 资源点管理表对象
   * @return
   */
  @SysLog("修改资源点管理表")
  @SysLogMethod(operation = "修改", blockName = "资源点管理", detail = "修改资源点信息")
  @ApiOperation(value = "修改资源点管理表数据", notes = "修改资源点管理表数据")
  @PostMapping("/update")
  public R update(@RequestBody @ApiParam(value = "资源点管理表实体对象", required = true) LiResource bean) {
    ValidatorUtils.validateEntity(bean);
    bean.setUpdateUserId(getUserId());
    bean.setUpdateTime(new Date());
    bean.setSysSign(getUser().getSysSystem().getCode());
    liResourceService.update(
        bean,
        new QueryWrapper<LiResource>()
            .eq(StringUtil.checkNotNull(bean.getId()), "id", bean.getId()));
    return R.ok();
  }

  /**
   * 修改
   *
   * @param list 资源点管理表对象
   * @return
   */
  @SysLog("批量修改资源点管理表")
  @SysLogMethod(operation = "修改", blockName = "资源点管理", detail = "批量修改资源点信息")
  @ApiOperation(value = "批量修改资源点管理表数据", notes = "批量修改资源点管理表数据")
  @PostMapping("/updateList")
  public R updateList(
      @RequestBody @ApiParam(value = "资源点管理表实体对象", required = true) List<LiResource> list) {
    if (list != null && list.size() > 0) {
      list.forEach(
          (res) -> {
            res.setUpdateUserId(getUserId());
            res.setUpdateTime(new Date());
            res.setSysSign(getUser().getSysSystem().getCode());
          });
      liResourceService.updateBatchById(list);
    }
    return R.ok();
  }

  /**
   * 根据ID获取资源点管理表对象
   *
   * @param id 对象主键
   * @return
   */
  @ApiOperation(value = "根据ID获取资源点管理表对象", notes = "根据ID获取资源点管理表对象")
  @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
  @GetMapping("/getId/{id}")
  public R getId(@PathVariable String id) {
    LiResource bean = liResourceService.getBeanById(id);
    return R.ok().put("bean", bean);
  }

  /**
   * 根据ID获取资源点管理表详情对象
   *
   * @param id 对象主键
   * @return
   */
  @ApiOperation(value = "根据ID获取资源点管理表详情对象", notes = "根据ID获取资源点管理表详情对象")
  @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
  @GetMapping("/getResourceDetails/{id}")
  public R getResourceDetails(@PathVariable String id) {
    LiResource bean = liResourceService.getBeanById(id);
    Map<String, Object> resourceDetailsMap =
        JSONObject.parseObject(JSONObject.toJSONString(bean), Map.class);
	// 线路站点
    resourceDetailsMap.put("lineStation", bean.getLineName() + "-" + bean.getStationName());
	// 告警等级
    resourceDetailsMap.put("alarmLevel", "无");
    if (!Constants.STRING_01.equals(bean.getSubCode())) {
      // 如果不是摄像头，返回摄像头列表
      List<LiResourceCamera> list = liResourceCameraService.getByResourceId(bean.getId());
      ArrayList<String> ids = new ArrayList<>();
      for (LiResourceCamera liResourceCamera : list) {
        ids.add(liResourceCamera.getCameraId());
      }
      if (ids.size() > 0) {
        List<LiResource> resourceList = liResourceService.getByIds(ids);
	// 关联的摄像头列表
        resourceDetailsMap.put("list", resourceList);
      }
    }
    return R.ok().put("bean", resourceDetailsMap);
  }

  /**
   * 根据ID获取资源点管理表对象
   *
   * @param ids 资源点管理表对象主键数组
   * @return
   */
  @SysLog("删除资源点管理表")
  @SysLogMethod(operation = "删除", blockName = "资源点管理", detail = "删除资源点数据")
  @ApiOperation(value = "根据ID批量删除资源点管理表数据", notes = "根据ID批量删除资源点管理表数据")
  @ApiImplicitParam(name = "ids", value = "主键数组", required = true, dataType = "String[]")
  @PostMapping("/delete")
  public R delete(@RequestBody String[] ids) {
    liResourceService.deleteByIds(Arrays.asList(ids));
    return R.ok();
  }

  /**
   * 获取线路-站点-资源点树
   *
   * @param model 承接对象
   * @return
   */
  @ApiOperation(value = "获取线路-站点-资源点树", notes = "获取线路-站点-资源点树")
  @ApiImplicitParam(name = "model", value = "参数", required = true, dataType = "LiResourceModel")
  @PostMapping("/getTreeList")
  public R getTreeList(@RequestBody LiResourceModel model) {
    // 默认只查询一个站点
    List<Map<String, Object>> tree = new ArrayList<>();
    if (StringUtil.checkNotNull(model.getStationId())) {
      tree = getStationTreeList(model);
    } else {
      tree = getAllTreeList(model);
    }

    return R.ok().put("tree", tree);
  }

  private List<Map<String, Object>> getAllTreeList(LiResourceModel model) {
    List<Map<String, Object>> tree = new ArrayList<>();
    Map<String, Object> root = new HashMap<>(5);
    root.put("name", "资源点列表");
    root.put("id", "0");
    root.put("level", 1);
    LiLineModel lineModel = new LiLineModel();
    List<LiLine> lineList = liLineService.getTreeList(lineModel);
    LiStationModel stationModel = new LiStationModel();
    List<LiStation> stationList = liStationService.getTreeList(stationModel);
    List<Map<String, Object>> childrenRoot = new ArrayList<>();
    if (lineList != null && lineList.size() > 0) {
      lineList.forEach(
          (liLine) -> {
            Map<String, Object> map =
                JSONObject.parseObject(JSONObject.toJSONString(liLine), Map.class);
            map.put("level", 2);
            List<Map<String, Object>> childrenLine = new ArrayList<>();
            stationList.forEach(
                (liStation) -> {
                  if (liLine.getId().equals(liStation.getLineId())) {
                    Map<String, Object> mapStation =
                        JSONObject.parseObject(JSONObject.toJSONString(liStation), Map.class);
                    mapStation.put("name", liStation.getStationName());
                    mapStation.put("level", 3);
                    childrenLine.add(mapStation);
                  }
                });
            map.put("children", childrenLine);
            childrenRoot.add(map);
          });
    }
    root.put("children", childrenRoot);
    tree.add(root);
    return tree;
  }

  private List<Map<String, Object>> getStationTreeList(LiResourceModel model) {
    List<Map<String, Object>> tree = new ArrayList<>();
    LiStation station = liStationService.getById(model.getStationId());
    Map<String, Object> root = JSONObject.parseObject(JSONObject.toJSONString(station), Map.class);
    root.put("name", station.getStationName());
    root.put("key", UUID.randomUUID());
    root.put("level", 3);
    tree.add(root);
    return tree;
  }

  /**
   * 根据站点id查询站点地图
   *
   * @param model 承接对象
   * @return
   */
  @ApiOperation(value = "根据站点id查询站点地图", notes = "根据站点id查询站点地图")
  @ApiImplicitParam(name = "model", value = "参数", required = true, dataType = "LiStationMapModel")
  @PostMapping("/getStationMapTreeList")
  public R getStationMapTreeList(@RequestBody LiStationMapModel model) {
    List<LiStationMap> list = liStationMapService.getTreeList(model);
    List<SysDictionary> dicList =
        sysDictionaryService.queryByPid(Constants.SUB_SYSTEM_ID, model.getStationId());
    LiResourceModel resourceModel = new LiResourceModel();
    resourceModel.setStationId(model.getStationId());
    List<LiResource> resourceList = liResourceService.getTreeList(resourceModel);
    List<Map<String, Object>> nodes = new ArrayList<>();
    list.forEach(
        (liStationMap) -> {
          Map<String, Object> mapStationMap =
              JSONObject.parseObject(JSONObject.toJSONString(liStationMap), Map.class);
          mapStationMap.put("key", UUID.randomUUID());
          mapStationMap.put("level", 4);
          List<Map<String, Object>> childrenStationMap = new ArrayList<>();
          dicList.forEach(
              (dic) -> {
                Map<String, Object> mapDic = getStringObjectMapDic(liStationMap, dic,null);
                List<Map<String, Object>> childrenDic = new ArrayList<>();
                resourceList.forEach(
                    (resource) -> {
                      if (dic.getValue().equals(resource.getSubCode())
                          && liStationMap.getId().equals(resource.getTierId())) {
                        Map<String, Object> mapResource =
                            JSONObject.parseObject(JSONObject.toJSONString(resource), Map.class);
                        mapResource.put("level", 6);
                        mapResource.put("active", false);
                        // 拖拽的唯一标识
                        mapResource.put("key", UUID.randomUUID());
                        childrenDic.add(mapResource);
                      }
                    });
                mapDic.put("children", childrenDic);
                childrenStationMap.add(mapDic);
              });
          mapStationMap.put("children", childrenStationMap);
          nodes.add(mapStationMap);
        });
    return R.ok().put("nodes", nodes);
  }

  /**
   * 根据站点id和子系统编码查询站点地图(如有资源点名则模糊查询)
   *
   * @param model 承接对象 stationId 当前站点id subCode 子系统编码 resourceName 资源点名
   * @return
   */
  @ApiOperation(value = "根据站点id和子系统编码查查询站点地图", notes = "根据站点id和子系统编码查查询站点地图")
  @ApiImplicitParam(name = "model", value = "参数", required = true, dataType = "LiStationMapModel")
  @PostMapping("/getStationMapCodeTreeList")
  public R getStationMapCodeTreeList(@RequestBody LiStationMapModel model) {
	// 有传子系统编码，为5大模块电子地图
    if (!"".equals(model.getSubCode()) && model.getSubCode() != null) {
      List<Map<String, Object>> nodes = getMapsForModule(model);
      return R.ok().put("nodes", nodes);
    } else {
      // 没传子系统编码，为电子地图首页
      List<Map<String, Object>> tree = getMapsForMaps(model);
      return R.ok().put("nodes", tree);
    }
  }

  /**
   * 五大子模块资源树
   * @param model
   * @return
   */
  private List<Map<String, Object>> getMapsForModule(@RequestBody LiStationMapModel model) {
    List<Map<String, Object>> nodes = new ArrayList<>();
	// 如果是视频监控-实时监控，一级不让勾选
    int pd = 0;
    if (model.getByx1() != null && !"".equals(model.getByx1()) && Constants.SP.equals(model.getByx1())) {
      pd = 1;
      model.setByx1(null);
    }
    // 查询当前站点相应所有层级
    List<LiStationMap> list = liStationMapService.getTreeList(model);
    if (list != null && list.size() > 0) {
      for (int i = 0; i < list.size(); i++) {
        Map<String, Object> map = JSONObject.parseObject(JSONObject.toJSONString(list.get(i)), Map.class);
	// 站层等级
        map.put("level", 4);
        if (pd == 1) {
	// 如果是视频监控-实时监控，一级不让勾选
          map.put("disabled", true);
        }
        LiResourceModel resourceModel = new LiResourceModel();
	// 当前站点id
        resourceModel.setStationId(model.getStationId());
	// 子系统编码
        resourceModel.setSubCode(model.getSubCode());
	// 站层id
        resourceModel.setTierId(list.get(i).getId());
	// 资源点类型
        resourceModel.setType(model.getResourceType());
        resourceModel.setName(model.getResourceName());
        // 查询当前站层下，所有符合条件的子系统的资源点
        List<LiResource> resourceList = liResourceService.getTreeListByModel(resourceModel);
        if (resourceList != null && resourceList.size() > 0) {
          List<Map<String, Object>> childrenDic = new ArrayList<>();
          for (int j = 0; j < resourceList.size(); j++) {
            Map<String, Object> mapChildren = JSONObject.parseObject(JSONObject.toJSONString(resourceList.get(j)), Map.class);
            // 设置在线和离线状态标记---资源点名称+状态
            String name = resourceList.get(j).getName();
            String byx2 = resourceList.get(j).getByx2();
	// 证明有在线状态更新
            if (byx2 != null && !"".equals(byx2)) {
              if ("1".equals(byx2)) {
                name = name + "[在线]";
              } else {
                name = name + "[离线]";
              }
	// 资源点名称
              mapChildren.put("name", name);
            }
	// 等级
            mapChildren.put("level", 6);
            mapChildren.put("imageSrc", resourceList.get(j).getImageSrc());
	// 父id  也就是站层id
            mapChildren.put("pid", resourceList.get(j).getTierId());
            childrenDic.add(mapChildren);
          }
	// 把当前站层下所有的资源点，绑定到站层上
          map.put("children", childrenDic);
        }
	// 把当前站层所有数据，让如树中
        nodes.add(map);
      }
    }
    return nodes;
  }

  /**
   * 电子地图页资源树
   * @param model
   * @return
   */
  private List<Map<String, Object>> getMapsForMaps(@RequestBody LiStationMapModel model) {
    List<Map<String, Object>> tree = new ArrayList<>();
    LiStation station = liStationService.getById(model.getStationId());
    Map<String, Object> root = JSONObject.parseObject(JSONObject.toJSONString(station), Map.class);
    root.put("name", station.getStationName());
    root.put("key", UUID.randomUUID());
    root.put("level", 3);

    // 查询该站点下站层地图
    LiStationMapModel mapModel = new LiStationMapModel();
    mapModel.setStationId(model.getStationId());
    List<LiStationMap> list = liStationMapService.getTreeList(mapModel);

    // 查询子系统字典项
    List<SysDictionary> dicList = new ArrayList<>();
    dicList = sysDictionaryService.queryByPid(Constants.SUB_SYSTEM_ID, model.getStationId());

    // 查询该站点下所有资源点
    LiResourceModel lrm = new LiResourceModel();
    lrm.setStationId(model.getStationId());
    List<LiResource> resourceList = liResourceService.getTreeList(lrm);

    List<InvadeDefence> invadeDefenceList2 = invadeDefenceService.getByStationId(model.getStationId());

    List<Map<String, Object>> nodes = new ArrayList<>();
    for (LiStationMap liStationMap : list) {
      Map<String, Object> mapStationMap = JSONObject.parseObject(JSONObject.toJSONString(liStationMap), Map.class);
      mapStationMap.put("key", UUID.randomUUID());
      mapStationMap.put("level", 4);
      mapStationMap.put("lineId",station.getLineId());
      List<Map<String, Object>> childrenStationMap = new ArrayList<>();
      for (SysDictionary dic : dicList) {
        Map<String, Object> mapDic = getStringObjectMapDic(liStationMap, dic,station.getLineId());
        List<Map<String, Object>> childrenDic = new ArrayList<>();
        if ("03".equals(dic.getValue())) {
          getChildDicInvadeDefence(model, invadeDefenceList2, liStationMap, childrenDic,station.getLineId());
        } else {
          // 不是防区，放入资源点就行
          getChildrenDicResource(resourceList, liStationMap, dic, childrenDic);
        }

        mapDic.put("children", childrenDic);
	// 如果该子系统下无资源点，不展示
        if (childrenDic != null && childrenDic.size() > 0) {
          childrenStationMap.add(mapDic);
        }
      }
      mapStationMap.put("children", childrenStationMap);
      nodes.add(mapStationMap);
    }
    root.put("children", nodes);
    tree.add(root);
    return tree;
  }

  /**
   * 防区加载资源点
   * @param model
   * @param invadeDefenceList2
   * @param liStationMap
   * @param childrenDic
   */
  private void getChildDicInvadeDefence(@RequestBody LiStationMapModel model, List<InvadeDefence> invadeDefenceList2, LiStationMap liStationMap, List<Map<String, Object>> childrenDic,String lineId) {
    // 循环判断，当前层级是否存在防区
    List<InvadeDefence> invadeDefenceList = new ArrayList<InvadeDefence>();
    if (invadeDefenceList2 != null && invadeDefenceList2.size() > 0) {
      String id = liStationMap.getId();
      for (int ik = 0; ik < invadeDefenceList2.size(); ik++) {
        String tierId = invadeDefenceList2.get(ik).getTierId();
        if (id == tierId || id.equals(tierId)) {
          invadeDefenceList.add(invadeDefenceList2.get(ik));
        }
      }
    }
    if (invadeDefenceList != null && invadeDefenceList.size() > 0) {
      for (int j = 0; j < invadeDefenceList.size(); j++) {
        InvadeDefence invadeDefence = invadeDefenceList.get(j);
        Map<String, Object> mapChildren = getStringObjectMapInvadeDefence(invadeDefence,lineId);
        List<LiResource> resourceList2 = liResourceService.queryByDefenceId(invadeDefenceList.get(j).getId());
        if (resourceList2 != null && resourceList2.size() > 0) {
          List<Map<String, Object>> childrenDic2 = new ArrayList<>();
          for (int k = 0; k < resourceList2.size(); k++) {
            Boolean resourceNameEqual = StringUtil.isEmpty(model.getResourceName()) || StringUtil.checkNotNull(model.getResourceName()) && resourceList2.get(k).getName().contains(model.getResourceName());
            if (resourceNameEqual) {
              getResourceChildrenMap(invadeDefenceList, j, invadeDefence, resourceList2, childrenDic2, k);
            }
          }
	// 把当前防区下所有的资源，绑定到防区
          mapChildren.put("children", childrenDic2);
        }
        childrenDic.add(mapChildren);
      }
    }
  }

  /**
   * 不是防区，放入资源点就行
   * @param resourceList
   * @param liStationMap
   * @param dic
   * @param childrenDic
   */
  private void getChildrenDicResource(List<LiResource> resourceList, LiStationMap liStationMap, SysDictionary dic, List<Map<String, Object>> childrenDic) {
    resourceList.forEach((resource) -> {
          if (dic.getValue().equals(resource.getSubCode()) && liStationMap.getId().equals(resource.getTierId())) {
            Map<String, Object> mapResource = JSONObject.parseObject(JSONObject.toJSONString(resource), Map.class);
            // 设置在线和离线状态标记---资源点名称+状态
            String name = resource.getName();
            String byx2 = resource.getByx2();
	// 证明有在线状态更新
            if (byx2 != null && !"".equals(byx2)) {
              if (Constants.STRING_1.equals(byx2)) {
                name = name + "[在线]";
              } else {
                name = name + "[离线]";
              }
	// 资源点名称
              mapResource.put("name", name);
            }
            mapResource.put("level", 6);
            mapResource.put("active", false);
            // 拖拽的唯一标识
            mapResource.put("key", UUID.randomUUID());
            childrenDic.add(mapResource);
          }
        });
  }

  /**
   * 获取字典子集
   * @param liStationMap
   * @param dic
   * @return
   */
  private Map<String, Object> getStringObjectMapDic(LiStationMap liStationMap, SysDictionary dic,String lineId) {
    Map<String, Object> mapDic = JSONObject.parseObject(JSONObject.toJSONString(dic), Map.class);
    // 两个id拼接保证id的唯一性
    mapDic.put("id", liStationMap.getId() + dic.getId());
    mapDic.put("code", dic.getValue());
    mapDic.put("stationId", liStationMap.getStationId());
    mapDic.put("lineId", lineId);
    mapDic.put("tierId", liStationMap.getId());
    mapDic.put("key", UUID.randomUUID());
    mapDic.put("level", 5);
    return mapDic;
  }

  /**
   * 获取防区子集
   * @param invadeDefence
   * @return
   */
  private Map<String, Object> getStringObjectMapInvadeDefence(InvadeDefence invadeDefence,String lineId) {
    Map<String, Object> mapChildren = JSONObject.parseObject(JSONObject.toJSONString(invadeDefence), Map.class);
	// 是否防区标识
    mapChildren.put("isDefence", true);
    mapChildren.put("active", false);
	// 拖拽的唯一标识
    mapChildren.put("key", UUID.randomUUID());
	// 等级
    mapChildren.put("level", 6);
    mapChildren.put("lineId", lineId);
    return mapChildren;
  }

  /**
   * 获取资源点子集
   * @param invadeDefenceList
   * @param j
   * @param invadeDefence
   * @param resourceList2
   * @param childrenDic2
   * @param k
   */
  private void getResourceChildrenMap(List<InvadeDefence> invadeDefenceList, int j, InvadeDefence invadeDefence, List<LiResource> resourceList2, List<Map<String, Object>> childrenDic2, int k) {
    Map<String, Object> mapChildren2 = JSONObject.parseObject(JSONObject.toJSONString(resourceList2.get(k)), Map.class);
    if (mapChildren2 != null) {
      // 设置在线和离线状态标记---资源点名称+状态
      String name = resourceList2.get(k).getName();
      String byx2 = resourceList2.get(k).getByx2();
	// 证明有在线状态更新
      if (byx2 != null && !"".equals(byx2)) {
        if (Constants.STRING_1.equals(byx2)) {
          name = name + "[在线]";
        } else {
          name = name + "[离线]";
        }
	// 资源点名称
        mapChildren2.put("name", name);
      }
      mapChildren2.put("active", false);
      // 拖拽的唯一标识
      mapChildren2.put("key", UUID.randomUUID());
	// 等级
      mapChildren2.put("level", 7);
      mapChildren2.put("pid", invadeDefenceList.get(j).getId());
      mapChildren2.put("p_xpoint", invadeDefence.getXpoint());
      mapChildren2.put("p_ypoint", invadeDefence.getYpoint());
      mapChildren2.put("p_xlongit", invadeDefence.getXlongit());
      mapChildren2.put("p_ylat", invadeDefence.getYlat());
      childrenDic2.add(mapChildren2);
    }
  }

  /**
   * 根据站点id和子系统编码查询站点地图(如有资源点名则模糊查询) 安全检查 实时安检
   *
   * @param model 承接对象 stationId 当前站点id subCode 子系统编码 resourceName 资源点名
   * @return
   */
  @ApiOperation(value = "根据站点id和子系统编码查查询站点地图", notes = "根据站点id和子系统编码查查询站点地图")
  @ApiImplicitParam(name = "model", value = "参数", required = true, dataType = "LiStationMapModel")
  @PostMapping("/getAJStationMapCodeTreeList")
  public R getAjStationMapCodeTreeList(@RequestBody LiStationMapModel model) {
    List<Map<String, Object>> nodes = new ArrayList<>();
    // 查询当前站点相应所有层级
    List<LiStationMap> list = liStationMapService.getTreeList(model);
    if (list != null && list.size() > 0) {
      for (int i = 0; i < list.size(); i++) {
        Map<String, Object> map =
            JSONObject.parseObject(JSONObject.toJSONString(list.get(i)), Map.class);
	// 站层等级
        map.put("level", 4);

        LiResourceModel resourceModel = new LiResourceModel();
	// 当前站点id
        resourceModel.setStationId(model.getStationId());
	// 子系统编码
        resourceModel.setSubCode(model.getSubCode());
	// 站层id
        resourceModel.setTierId(list.get(i).getId());
	// 资源点类型
        resourceModel.setType(model.getResourceType());
        resourceModel.setName(model.getResourceName());
        // 查询当前站层下，所有符合条件的子系统的资源点
        List<LiResource> resourceList = liResourceService.getTreeListByModel(resourceModel);
        List<Map<String, Object>> childrenDic = new ArrayList<>();
        if (resourceList != null && resourceList.size() > 0) {
          for (int j = 0; j < resourceList.size(); j++) {
            Map<String, Object> mapChildren =
                JSONObject.parseObject(JSONObject.toJSONString(resourceList.get(j)), Map.class);

            // 设置在线和离线状态标记---资源点名称+状态
            String name = resourceList.get(j).getName();
            String byx2 = resourceList.get(j).getByx2();
	// 证明有在线状态更新
            if (byx2 != null && !"".equals(byx2)) {
              if ("1".equals(byx2)) {
                name = name + "[在线]";
              } else {
                name = name + "[离线]";
              }
	// 资源点名称
              mapChildren.put("name", name);
            }
	// 等级
            mapChildren.put("level", 6);
	// 父id  也就是站层id
            mapChildren.put("pid", resourceList.get(j).getTierId());
            childrenDic.add(mapChildren);
          }
	// 把当前站层下所有的资源点，绑定到站层上
          map.put("children", childrenDic);
        }
        if (childrenDic != null && childrenDic.size() > 0) {
	// 把当前站层所有数据，让如树中
          nodes.add(map);
        }
      }
    }
    return R.ok().put("nodes", nodes);
  }

  /**
   * 根据站点id查询球形摄像机站点地图(如有资源点名则模糊查询)
   *
   * @param model 承接对象 stationId 当前站点id resourceName 资源点名
   * @return
   */
  @ApiOperation(value = "根据站点id查询球形摄像机站点地图", notes = "根据站点id查询球形摄像机站点地图")
  @ApiImplicitParam(name = "model", value = "参数", required = true, dataType = "LiStationMapModel")
  @PostMapping("/getSphericalCameraStationMap")
  public R getSphericalCameraStationMap(@RequestBody LiStationMapModel model) {
    List<Map<String, Object>> nodes = new ArrayList<>();
    // 查询当前站点相应所有层级
    List<LiStationMap> list = liStationMapService.getTreeList(model);
    if (list != null && list.size() > 0) {
      for (int i = 0; i < list.size(); i++) {
        Map<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("id", list.get(i).getId());
	// 站层名称
        map.put("name", list.get(i).getName());
	// 站层等级
        map.put("level", 4);

        LiResourceModel resourceModel = new LiResourceModel();
	// 当前站点id
        resourceModel.setStationId(model.getStationId());
	// 站层id
        resourceModel.setTierId(list.get(i).getId());
        resourceModel.setType("ece0b8b2db27411886254e81134988a3");
        resourceModel.setName(model.getResourceName());
        // 查询当前站层下，所有符合条件的球机
        List<LiResource> resourceList = liResourceService.getTreeListByModel(resourceModel);
        if (resourceList != null && resourceList.size() > 0) {
          List<Map<String, Object>> childrenDic = new ArrayList<>();
          for (int j = 0; j < resourceList.size(); j++) {
            Map<String, Object> mapChildren = new LinkedHashMap<String, Object>();
            mapChildren.put("id", resourceList.get(j).getId());
	// 资源点名称
            mapChildren.put("name", resourceList.get(j).getName());
	// 资源点编码
            mapChildren.put("code", resourceList.get(j).getCode());
	// 等级
            mapChildren.put("level", 6);
	// 父id  也就是站层id
            mapChildren.put("pid", resourceList.get(j).getTierId());
            childrenDic.add(mapChildren);
          }
	// 把当前站层下所有的资源点，绑定到站层上
          map.put("children", childrenDic);
          // 没有子节点的不添加到树中--------ck 2020-8-19 09:22:48调整
	// 把当前站层所有数据，让如树中
          nodes.add(map);
        }
      }
    }
    return R.ok().put("nodes", nodes);
  }

  /**
   * 根据站点地图id子系统编码查询站点地图
   *
   * @param model 承接对象
   * @return
   */
  @ApiOperation(value = "根据站点地图id子系统编码查询站点地图", notes = "根据站点地图id子系统编码查询站点地图")
  @ApiImplicitParam(name = "model", value = "参数", required = true, dataType = "LiResourceModel")
  @PostMapping("/getResourceTreeList")
  public R getResourceTreeList(@RequestBody LiResourceModel model) {
    List<LiResource> list = liResourceService.getTreeList(model);
    List<Map<String, Object>> nodes = new ArrayList<>();
    list.forEach(
        (resource) -> {
          Map<String, Object> mapResource =
              JSONObject.parseObject(JSONObject.toJSONString(resource), Map.class);
          mapResource.put("key", UUID.randomUUID());
          mapResource.put("level", 6);
          nodes.add(mapResource);
        });
    return R.ok().put("nodes", nodes);
  }

  /**
   * 根据资源点父级id查询安检机，所关联的前后摄像头
   *
   * @param id parent_name
   * @return
   */
  @ApiOperation(value = "根据ID获取资源点管理表详情对象", notes = "根据ID获取资源点管理表详情对象")
  @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
  @GetMapping("/inspectGl/{id}")
  public R inspectGl(@PathVariable String id) {
    List<LiResource> list = liResourceService.queryByParent(id);
    return R.ok().put("list", list);
  }

  /** 根据站点id和子系统编码获取所有设备 */
  @ApiOperation(value = "根据站点id和子系统编码获取所有设备", notes = "根据站点id和子系统编码获取所有设备")
  @GetMapping("/getAllEq")
  R getAllEq(String stationId, String subCode) {
    List<LiResource> list = liResourceService.getAllEq(stationId, subCode);
    return R.ok().put("list", list);
  }
}
