package com.devplatform.equipment.modules.liresource.dao;

import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.liresource.bean.LiResource;
import com.devplatform.equipment.modules.liresource.model.LiResourceModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

/**
 * LiResource Mapper 用于资源点管理表的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface LiResourceDao extends MyBaseMapper<LiResource> {

  /**
   * 查询资源点数量
   * @param model
   * @return
   */
  Integer queryPageByCount(LiResourceModel model);

  /**
   * 查询资源点数据
   * @param model
   * @return
   */
  List<LiResource> queryPageByList(LiResourceModel model);

  /**
   * 批量删除资源点
   * @param list
   */
  void deleteByIds(List<String> list);

  /**
   * 查询资源点树信息
   * @param model
   * @return
   */
  List<LiResource> getTreeList(LiResourceModel model);

  /**
   * 根据id查询资源点信息
   * @param id
   * @return
   */
  LiResource getBeanById(String id);

  /**
   * 根据id查询资源点信息
   * @param ids
   * @return
   */
  List<LiResource> getByIds(List<String> ids);

  /**
   * 查询资源点树
   * @param resourceModel
   * @return
   */
  List<LiResource> getTreeListByModel(LiResourceModel resourceModel);

  /**
   * 查询所有资源点名称
   * @param model
   * @return
   */
  List<String> getAllResourceNameList(LiResourceModel model);

  /**
   * 根据ids查询资源点
   * @param ids
   * @return
   */
  List<LiResource> getNormalByIds(ArrayList<String> ids);

  /**
   * 根据条件查询资源点
   * @param lrm
   * @return
   */
  List<LiResource> queryByEnshrine(LiResourceModel lrm);

  /**
   * 根据防区id查询资源点
   * @param id
   * @return
   */
  List<LiResource> queryByDefenceId(String id);

  /**
   * 根据父节点名称查询资源点
   * @param id
   * @return
   */
  List<LiResource> queryByParent(String id);

  /**
   * 根据子系统编码查询资源点
   * @param stationId
   * @param subCode
   * @return
   */
  List<LiResource> getAllEq(@Param("stationId") String stationId, @Param("subCode") String subCode);

  /**
   * 根据资源id获取对应图层排序值
   * @param id
   * @return
   */
  String getOrderNumByResId(String id);

  /**
   * 根据id查询资源点
   * @param id
   * @return
   */
  LiResource queryById(String id);
}
