package com.devplatform.equipment.modules.liresource.service;

import com.devplatform.common.service.MyBaseService;
import com.devplatform.equipment.modules.liresource.bean.LiResource;
import com.devplatform.equipment.modules.liresource.model.LiResourceModel;
import java.util.ArrayList;
import java.util.List;

/**
 * 资源点管理表的service接口 <br>
 * <b>功能：</b>LiResourceService<br>
 *
 * @author 代码生成器产生
 */
public interface LiResourceService extends MyBaseService<LiResource> {

  /**
   * 分页查询
   *
   * @param model
   * @return
   */
  List<LiResource> queryPageByList(LiResourceModel model);

  /**
   * 逻辑删除
   *
   * @param list
   */
  void deleteByIds(List<String> list);

  /**
   * 获取线路-站点-资源点树
   *
   * @param model
   * @return
   */
  List<LiResource> getTreeList(LiResourceModel model);

  /**
   * 根据id获取资源点信息
   *
   * @param id
   * @return
   */
  LiResource getBeanById(String id);

  /**
   * 根据id集合获取资源点信息
   *
   * @param ids
   * @return
   */
  List<LiResource> getByIds(List<String> ids);

  /**
   * 查询资源点树
   * @param resourceModel
   * @return
   */
  List<LiResource> getTreeListByModel(LiResourceModel resourceModel);

  /**
   * 查询资源点名称
   * @param model
   * @return
   */
  List<String> getAllResourceNameList(LiResourceModel model);

  /**
   * 根据id集合获取未被删除资源点信息
   * @param resourceIds
   * @return
   */
  List<LiResource> getNormalByIds(ArrayList<String> resourceIds);

  /**
   * 查询收藏夹所有资源点信息
   *
   * @param lrm
   * @return
   */
  List<LiResource> queryByEnshrine(LiResourceModel lrm);

  /**
   * 查询防区下所有资源点
   *
   * @param id
   * @return
   */
  List<LiResource> queryByDefenceId(String id);

  /**
   * 根据父节点名称查询资源点
   * @param id
   * @return
   */
  List<LiResource> queryByParent(String id);

  /**
   * 根据子系统编码查询所有资源点
   * @param stationId
   * @param subCode
   * @return
   */
  List<LiResource> getAllEq(String stationId, String subCode);

  /**
   * 根据资源id获取对应图层排序值
   * @param id
   * @return
   */
  String getOrderNumByResId(String id);

  /**
   * 根据资源点id查询资源点
   * @param id
   * @return
   */
  LiResource queryById(String id);
}
